        $(document).ready(function () {
            // 注册AI助手按钮
            UE.registerUI('aiassistant', function (editor, uiName) {

                // 创建按钮
                var btn = new UE.ui.Button({
                    name: uiName,
                    title: 'AI文案助手',
                    onclick: function () {
                        return false;
                    }
                });
                return btn;
            });

            // 初始化编辑器
            var defaultToolbars = window.UEDITOR_CONFIG.toolbars[0].slice();
            defaultToolbars.push('aiassistant');
            var ue = UE.getEditor('editor', {
                toolbars: [defaultToolbars]
            });

            // 编辑器就绪后添加下拉菜单
            ue.ready(function () {
                // 只添加一次
                if ($('.ai-dropdown-menu').length) return;

                var aiButton = $('.edui-for-aiassistant');
                if (aiButton.length === 0) return;

                // 下拉菜单HTML
                var dropdownHtml = `
                    <div class="ai-dropdown-menu" style="display:none; position:absolute;">
                    <div class="ai-dropdown-item" data-action="content-generate">
                        <i class="ai-icon layui-icon layui-icon-edit"></i>
                        <span>文案生成</span>
                    </div>
                    <div class="ai-dropdown-item" data-action="style-format">
                        <i class="ai-icon layui-icon layui-icon-theme"></i>
                        <span>样式排版</span>
                    </div>
                    </div>
                `;
                $('body').append(dropdownHtml);
                var dropdown = $('.ai-dropdown-menu');

                // 悬停显示下拉菜单
                aiButton.on('mouseenter', function () {
                    var offset = aiButton.offset();
                    dropdown.css({
                        top: offset.top + aiButton.outerHeight() + 2,
                        left: offset.left,
                        display: 'block'
                    });
                }).on('mouseleave', function () {
                    setTimeout(function () {
                        if (!dropdown.is(':hover')) dropdown.hide();
                    }, 200);
                });
                dropdown.on('mouseleave', function () {
                    dropdown.hide();
                });

                // 点击菜单项
                dropdown.on('click', '.ai-dropdown-item', function () {
                    var action = $(this).data('action');
                    dropdown.hide();
                    if (action === 'content-generate') {
                        // 调用AI助手弹窗
                        $('[lay-on="test-offset-r"]').click();
                    } else if (action === 'style-format') {
                        openStyleFormatter();
                    }
                });
            });
        });
        // ...existing code...

        // 样式排版弹窗函数
        function openStyleFormatter() {
            var editor = UE.getEditor('editor');
            var currentContent = editor.getContent();
            // 只保留纯文本，去除所有标签、空格、表格等
            var previewText = currentContent
                .replace(/<[^>]+>/g, '')      // 去除所有HTML标签
                .replace(/&nbsp;/g, '')      // 去除&nbsp;
                .replace(/\s+/g, '')         // 去除所有空白字符（包括空格、换行、制表符）
                .replace(/[\r\n]/g, '')  
                .replace(/[\u{1F600}-\u{1F64F}|\u{1F300}-\u{1F5FF}|\u{1F680}-\u{1F6FF}|\u{2600}-\u{26FF}|\u{2700}-\u{27BF}|\u{1F1E0}-\u{1F1FF}|\u{1F900}-\u{1F9FF}|\u{1FA70}-\u{1FAFF}|\u{200D}|\u{23CF}|\u{23E9}-\u{23F3}|\u{25FD}-\u{25FE}|\u{2614}-\u{2615}|\u{2648}-\u{2653}|\u{267F}|\u{2693}|\u{26A1}|\u{26AA}-\u{26AB}|\u{26BD}-\u{26BE}|\u{26C4}-\u{26C5}|\u{26CE}|\u{26D4}|\u{26EA}|\u{26F2}-\u{26F3}|\u{26F5}|\u{26FA}|\u{26FD}|\u{2702}|\u{2705}|\u{2708}-\u{2709}|\u{270A}-\u{270B}|\u{2728}|\u{274C}|\u{274E}|\u{2753}-\u{2755}|\u{2757}|\u{2795}-\u{2797}|\u{27B0}|\u{27BF}|\u{2B1B}-\u{2B1C}|\u{2B50}|\u{2B55}|\u{3030}|\u{303D}|\u{3297}|\u{3299}]/gu, ''); 

            var contentLength = previewText.length;

            // 读取缓存
            var seoTitleChecked = localStorage.getItem('style_ai_seo_title') === '1';
            var seoKeywordsChecked = localStorage.getItem('style_ai_seo_keywords') === '1';
            var seoDescChecked = localStorage.getItem('style_ai_seo_desc') === '1';
            var style = localStorage.getItem('style_format_style') || 'simple';
            var optimizeChecked = localStorage.getItem('style_optimize_checked') === '1';
            var optimizePrompt = localStorage.getItem('style_optimize_prompt') || '';

            var styleHtml = `
                <form class="layui-form" style="padding:15px;">
                    <div class="layui-form-item">
                        <label class="layui-form-label">排版风格</label>
                        <div class="layui-input-block">
                            <input type="radio" name="style" value="simple" title="经典风格" lay-filter="style-radio" ${style === 'simple' ? 'checked' : ''}>
                            <input type="radio" name="style" value="symbol" title="元素符号" lay-filter="style-radio" ${style === 'symbol' ? 'checked' : ''}>
                            <input type="radio" name="style" value="visualization" title="数据比对" lay-filter="style-radio" ${style === 'visualization' ? 'checked' : ''}>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">风格说明</label>
                        <div class="layui-input-block">
                            <div id="style-description" style="padding:8px 12px;background:#f8f9fa;border-radius:4px;border:1px solid #eee;color:#666;font-size:13px;"></div>
                        </div>
                    </div>

                    <div class="layui-form-item">
                        <label class="layui-form-label">内容预览</label>
                        <div class="layui-input-block">
                            <div style="max-height: 180px; overflow-y: auto; border: 1px solid #e6e6e6; padding: 10px; border-radius: 4px; background: #f8f9fa; font-size: 12px; color: #666; line-height: 1.5;word-wrap: break-word;">
                                ${previewText.replace(/<[^>]*>/g, '').substring(0, 300)}${previewText.replace(/<[^>]*>/g, '').length > 300 ? '...' : ''}
                            </div>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">优化内容</label>
                        <div class="layui-input-block">
                            <input type="checkbox" name="optimize" lay-skin="primary" title="启用优化" id="optimize-checkbox" lay-filter="optimize" ${optimizeChecked ? 'checked' : ''}>
                        </div>
                    </div>
                    <div class="layui-form-item" id="optimize-tip-row" style="display:none;">
                        <label class="layui-form-label">优化提示词</label>
                        <div class="layui-input-block">
                            <textarea id="optimize-prompt" class="layui-textarea" style="height:80px;" placeholder="可自定义AI优化提示词，如：翻译成英文、扩写或缩写字数，留空则不改变原内容字数">${optimizePrompt}</textarea>
                        </div>
                    </div>
                    <div class="layui-form-item" id="ai-seo-row">
                        <label class="layui-form-label">是否优化</label>
                        <div class="layui-input-block">
                            <input type="checkbox" id="ai-seo-title" lay-filter="ai-seo-title" title="标题" ${seoTitleChecked ? 'checked' : ''}>
                            <input type="checkbox" id="ai-seo-keywords" lay-filter="ai-seo-keywords" title="SEO关键词" ${seoKeywordsChecked ? 'checked' : ''}>
                            <input type="checkbox" id="ai-seo-desc" lay-filter="ai-seo-desc" title="SEO描述" ${seoDescChecked ? 'checked' : ''}>
                        </div>
                    </div>
                  
                    <div class="layui-form-item">
                        <div class="layui-input-block">
                            <button type="button" id="format-btn" class="layui-btn">开始样式排版</button>
                        </div>
                    </div>
                </form>
            `;

            var styleDescriptions = {
                simple: `经典风格：简洁、正式、结构清晰，适合大多数场景。`,
                symbol: `元素符号：符号丰富、视觉感强，适合新媒体、创意内容。`,
                visualization: `数据比对：数据化思维、更易理解、适合用于商业分析、报告等场景。`,
            };

            var style = localStorage.getItem('style_format_style') || 'simple';
            // 读取排版风格（radio）
            
            layer.open({
                type: 1,
                title: '样式排版',
                offset: 'r',
                anim: 'slideLeft',
                area: ['520px', '100%'],
                shade: 0.1,
                shadeClose: true,
                content: styleHtml,
                success: function (layero, index) {
                    layui.form.on('checkbox(ai-seo-title)', function (data) {
                        localStorage.setItem('style_ai_seo_title', data.elem.checked ? '1' : '0');
                    });
                    layui.form.on('checkbox(ai-seo-keywords)', function (data) {
                        localStorage.setItem('style_ai_seo_keywords', data.elem.checked ? '1' : '0');
                    });
                    layui.form.on('checkbox(ai-seo-desc)', function (data) {
                        localStorage.setItem('style_ai_seo_desc', data.elem.checked ? '1' : '0');
                    });

                    layui.form.on('checkbox(optimize)', function (data) {
                        localStorage.setItem('style_optimize_checked', data.elem.checked ? '1' : '0');
                        if (data.elem.checked) {
                            $('#optimize-tip-row').show();
                            $('#ai-seo-row').show();
                        } else {
                            $('#optimize-tip-row').hide();
                            $('#ai-seo-row').hide();
                        }
                    });
                    // 绑定优化提示词输入事件
                    $('#optimize-prompt').on('input', function () {
                            localStorage.setItem('style_optimize_prompt', $(this).val());
                    });
                    $(layero).find(".tips").on("mouseover", function () {
                        layer.tips($(this).data('content'), this);
                    });
                    layui.form.render();
                    $(layero).find('#style-description').html(styleDescriptions[style]);
                
                    $('#optimize-tip-row').hide();
                    $('#ai-seo-row').hide();
                    if (optimizeChecked) {
                        $('#optimize-tip-row').show();
                        $('#ai-seo-row').show();
                    }
                    

                    // 切换风格时更新说明
                    layui.form.on('radio(style-radio)', function (data) {
                        var selectedStyle = data.value;
                        localStorage.setItem('style_format_style', selectedStyle);
                        $(layero).find('#style-description').html(styleDescriptions[selectedStyle]);
                    });

                
                    // 绑定按钮点击事件
                    $(layero).on('click', '#format-btn', function () {
                        var editor = UE.getEditor('editor');
                        var content = editor.getContent()
                            .replace(/[\u{1F600}-\u{1F64F}|\u{1F300}-\u{1F5FF}|\u{1F680}-\u{1F6FF}|\u{2600}-\u{26FF}|\u{2700}-\u{27BF}|\u{1F1E0}-\u{1F1FF}|\u{1F900}-\u{1F9FF}|\u{1FA70}-\u{1FAFF}|\u{200D}|\u{23CF}|\u{23E9}-\u{23F3}|\u{25FD}-\u{25FE}|\u{2614}-\u{2615}|\u{2648}-\u{2653}|\u{267F}|\u{2693}|\u{26A1}|\u{26AA}-\u{26AB}|\u{26BD}-\u{26BE}|\u{26C4}-\u{26C5}|\u{26CE}|\u{26D4}|\u{26EA}|\u{26F2}-\u{26F3}|\u{26F5}|\u{26FA}|\u{26FD}|\u{2702}|\u{2705}|\u{2708}-\u{2709}|\u{270A}-\u{270B}|\u{2728}|\u{274C}|\u{274E}|\u{2753}-\u{2755}|\u{2757}|\u{2795}-\u{2797}|\u{27B0}|\u{27BF}|\u{2B1B}-\u{2B1C}|\u{2B50}|\u{2B55}|\u{3030}|\u{303D}|\u{3297}|\u{3299}]/gu, '');

                        if (!content.replace(/<img[^>]*>/gi, '').replace(/<[^>]+>/g, '').trim()) {
                            layer.msg('必须有内容才可以排版', { icon: 2 });
                            return;
                        }
                        if (content.length < 50) {
                            layer.msg('内容低于50字，不支持优化', { icon: 2 });
                            return;
                        }
                        // 获取当前风格
                        var style = $(layero).find('input[name="style"]:checked').val() || 'simple';
                        aiFormatContent(content, editor, style, index); 
                    });
                },
                
            });
        }


        // AI样式排版方法
        function aiFormatContent(content, editor, style, layerIndex) {
      
                // 获取自定义提示词
                var optimizeChecked = localStorage.getItem('style_optimize_checked') === '1';
                var customPrompt = '';
                if (optimizeChecked) {
                    customPrompt = $('#optimize-prompt').val() || '';
                }

                // 构建AI优化提示词
                var stylePrompt = '';
                if (style === 'symbol') {
                    stylePrompt = '风格要求：多用符号、emoji、视觉元素点缀，适合新媒体、创意内容。\n';
                } else if (style === 'visualization') {
                    stylePrompt = '风格要求：内容结构化、数据化，适合商业分析、报告，适当用表格、列表。\n';
                } else {
                    stylePrompt = '风格要求：简洁、正式、结构清晰，适合大多数场景。\n';
                }

                // 拼接最终prompt
                var prompt = '请对以下内容进行美观的AI样式排版优化，要求：\n'
                    + stylePrompt
                    + (customPrompt ? (customPrompt + '\n') : '')
                + '1. 段落用<p>标签，内联style="text-indent:2em;line-height:1.8;margin:10px 0;color:#333;font-size:15px;"。\n'
                + '2. 小标题用<h2>或<h3>，加粗，内联style="font-weight:bold;margin:18px 0 10px 0;color:#222;font-size:18px;"。\n'
                + '3. 列表用<ul>/<ol>和<li>，li内联style="margin:6px 0 6px 2em;font-size:15px;color:#333;"。\n'
                + '4. 强调内容用<strong>或<em>，并加style="color:#c00;font-weight:bold;"。\n'
                + '5. 禁止输出任何class、id、script、link、style标签。\n'
                + '6. 只输出HTML代码，不要任何说明和解释。\n'
                + '请严格在正文后用如下格式输出附加信息（不要省略分隔符和字段名，不要输出多余内容）：\n'
                + '---附加信息---\n'
                + '标题: [标题]\n'
                + 'SEO关键词: [关键词]\n'
                + 'SEO描述: [描述]\n\n'
                + '原始内容如下：\n' + content;

            var loadingIndex = layer.msg('AI正在优化内容，请稍候...', {
                icon: 16,
                shade: 0.3,
                time: 0
            });

            // 内容处理函数
            function processContent(rawContent) {
                var parts = rawContent.split('---附加信息---');
                var articleContent = parts[0] || rawContent;
                articleContent = articleContent
                    .replace(/```html/g, '')
                    .replace(/```/g, '')
                    .replace(/<p>\s*```html\s*<\/p>/gi, '')
                    .replace(/<p>\s*```<\/p>/gi, '')
                    .replace(/^\s*<p>\s*<\/p>/gi, '')
                    .replace(/^(#|>|-|\*|•|●|\d+\.)\s.*$/gm, '')
                    .replace(/^\s*\n+/g, '')
                    .replace(/\n{3,}/g, '\n\n')
                    .replace(/(<p>\s*){2,}/g, '<p>')
                    .replace(/(<\/p>\s*){2,}/g, '</p>')
                    .replace(/<style[\s\S]*?<\/style>/gi, '')
                    .replace(/<script[\s\S]*?<\/script>/gi, '')
                    .replace(/<!--[\s\S]*?-->/g, '')
                    .replace(/(<p>\s*)+<\/p>/gi, '')
                    .replace(/(<\/?p>\s*){2,}/gi, '</p>')
                    .replace(/^\s+|\s+$/g, '')
                    .replace(/^\n+|\n+$/g, '');
                return articleContent;
            }

            // 提取附加信息
            function extractInfo(rawContent) {
                var info = { title: '', description: '', keywords: '' };
                var match = rawContent.match(/---附加信息---([\s\S]*)$/);
                if (match) {
                    var add = match[1];
                    var t = add.match(/标题\s*[:：]\s*([^\n\r]+)/i);
                    var d = add.match(/SEO描述\s*[:：]\s*([^\n\r]+)/i);
                    var k = add.match(/SEO关键词\s*[:：]\s*([^\n\r]+)/i);
                    if (t) info.title = t[1].trim();
                    if (d) info.description = d[1].trim();
                    if (k) info.keywords = k[1].trim().replace(/，/g, ',');
                }
                return info;
            }


            // 生成session_id
            function generateUUID() {
                return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                    var r = Math.random() * 16 | 0,
                        v = c === 'x' ? r : (r & 0x3 | 0x8);
                    return v.toString(16);
                });
            }
            var session_id = generateUUID();

            fetch('https://wss.lke.cloud.tencent.com/v1/qbot/chat/sse', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    content: prompt,
                    session_id: session_id,
                    bot_app_key: "JHtuHqzf"
                })
            })
                .then(async response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    const reader = response.body.getReader();
                    const decoder = new TextDecoder('utf-8');
                    let aiContentBuffer = '';
                    let lastContent = '';

                    editor.setContent(''); // 先清空

                    async function streamReply() {
                        while (true) {
                            const { done, value } = await reader.read();
                            if (done) break;
                            const chunk = decoder.decode(value, { stream: true });
                            const lines = chunk.split('\n');
                            for (let line of lines) {
                                if (line.startsWith('data:')) {
                                    try {
                                        const dataStr = line.replace('data:', '').trim();
                                        if (dataStr && dataStr !== '[DONE]') {
                                            const json = JSON.parse(dataStr);
                                            if (json.payload && json.payload.content) {
                                                aiContentBuffer = json.payload.content;
                                                // 实时流式显示正文
                                                var articleContent = processContent(aiContentBuffer);
                                                if (articleContent && articleContent !== lastContent) {
                                                    lastContent = articleContent;
                                                    editor.setContent(articleContent);
                                                }
                                            }
                                        }
                                    } catch (e) { }
                                }
                            }
                        }

                        // 重点：流式结束后再做一次最终赋值，确保完整
                        var info = extractInfo(aiContentBuffer);

                        // 精准赋值到当前tab下的input/textarea，仅勾选项且内容有效才赋值
                        function setInputValue(name, value) {
                            var $input = $('div.layui-tab-item.layui-show [name="' + name + '"]');
                            if ($input.length) {
                                $input.val(value);
                            } else {
                                $('form.layui-form [name="' + name + '"]').first().val(value);
                            }
                        }

                        // 读取最新勾选状态
                        var optimizeChecked = localStorage.getItem('style_optimize_checked') === '1';
                        var seoTitleChecked = localStorage.getItem('style_ai_seo_title') === '1';
                        var seoKeywordsChecked = localStorage.getItem('style_ai_seo_keywords') === '1';
                        var seoDescChecked = localStorage.getItem('style_ai_seo_desc') === '1';

                        let assignMsg = [];
                        // 只有在启用优化的情况下才进行赋值
                        if (optimizeChecked) {
                            if (seoTitleChecked && info.title) {
                                setInputValue('title', info.title);
                                // 检查赋值是否成功
                                var $titleInput = $('div.layui-tab-item.layui-show [name="title"]');
                                if (!$titleInput.length) $titleInput = $('form.layui-form [name="title"]').first();
                                if ($titleInput.length && $titleInput.val() === info.title) {
                                    assignMsg.push('标题');
                                }
                            }
                            if (seoKeywordsChecked && info.keywords) {
                                setInputValue('keywords', info.keywords);
                                var $kwInput = $('div.layui-tab-item.layui-show [name="keywords"]');
                                if (!$kwInput.length) $kwInput = $('form.layui-form [name="keywords"]').first();
                                if ($kwInput.length && $kwInput.val() === info.keywords) {
                                    assignMsg.push('关键词');
                                }
                            }
                            if (seoDescChecked && info.description) {
                                setInputValue('description', info.description);
                                var $descInput = $('div.layui-tab-item.layui-show [name="description"]');
                                if (!$descInput.length) $descInput = $('form.layui-form [name="description"]').first();
                                if ($descInput.length && $descInput.val() === info.description) {
                                    assignMsg.push('描述');
                                }
                            }
                        }

                        // 关闭loading和弹窗
                        layer.close(loadingIndex);
                        if (typeof layerIndex !== 'undefined') {
                            layer.close(layerIndex);
                        }

                        // 清空本地存储
                        localStorage.removeItem('style_optimize_checked');
                        localStorage.removeItem('style_optimize_prompt');
                        localStorage.removeItem('style_format_style');
                        localStorage.removeItem('style_ai_seo_title');
                        localStorage.removeItem('style_ai_seo_keywords');
                        localStorage.removeItem('style_ai_seo_desc');

                        // 赋值结果提示
                        if (optimizeChecked && assignMsg.length > 0) {
                            // 构建弹窗内容
                            let html = '<div style="padding:20px 30px 10px 30px;font-size:15px;">';
                            if (seoTitleChecked && info.title) {
                                html += '<div style="margin-bottom:10px;"><b>标题：</b>' + $('<div>').text(info.title).html() + '</div>';
                            }
                            if (seoKeywordsChecked && info.keywords) {
                                html += '<div style="margin-bottom:10px;"><b>关键词：</b>' + $('<div>').text(info.keywords).html() + '</div>';
                            }
                            if (seoDescChecked && info.description) {
                                html += '<div style="margin-bottom:10px;"><b>描述：</b>' + $('<div>').text(info.description).html() + '</div>';
                            }
                            html += '</div>';
                            layer.open({
                                type: 1,
                                title: 'AI已优化并赋值',
                                area: '420px',
                                shadeClose: true,
                                btn: ['确定'],
                                content: html,
                                yes: function(index) {
                                    layer.close(index);
                                }
                            });
                        } else if (optimizeChecked && (seoTitleChecked || seoKeywordsChecked || seoDescChecked)) {
                            layer.msg('AI未能成功赋值标题/关键词/描述，请检查表单结构或AI返回内容！', { icon: 2, offset: '100px' });
                        } else {
                            layer.msg('AI样式优化完成！', { icon: 1, offset: '100px' });
                        }
                    }

                    streamReply();
                })
                .catch(error => {
                    layer.close(loadingIndex);
                    layer.msg('请求失败：' + error.message, { icon: 5, offset: '100px' });
                });
        }