<?php

namespace app\home;
use think\template\TagLib;
use think\facade\Db;
use think\facade\Request;

class Long extends TagLib
{
    // 定义标签
    protected $tags = [
        // 定义标签名
        'nav'=>['attr'=>'pid,num,order,offset','close'=>1],
        'list'=>['attr'=>'scode,num,order,offset','close'=>1],
        'banner'=>['attr'=>'gid,num,order,offset','close'=>1],
        'link'=>['attr'=>'gid,num,order,offset','close'=>1],
        'content'=>['attr'=>'id,scode','close'=>1],
        'pics'=>['attr'=>'id,num,offset','close'=>1],
        'tags'=>['attr'=>'id,num,offset','close'=>1],
        'search'=>['attr'=>'num','close'=>1],
    ];


    //导航以及分类处理
    public function tagNav($tag, $content)
    {
        // 获取并解析 pid 属性
        $pid=isset($tag['pid'])?$tag['pid']:0;

        // 获取限制数量，并确保其为整数
        $limit=isset($tag['num'])?intval($tag['num']):10; // 转换为整数

        // 获取排序方式
        $order=isset($tag['order'])?$tag['order']:'sort asc,id asc'; // 默认排序方式

        // 获取偏移量，并确保其为整数
        $offset=isset($tag['offset'])?intval($tag['offset']):0; // 默认偏移量为0

        // 简化处理逻辑
        $pidStr=trim($pid);

        // 标签模板格式
        $parseStr = '<?php ';

        // 处理变量形式的pid
        if(preg_match('/^\{?\$(.*)\}?$/', $pidStr, $matches)){
            $varName=str_replace(['{', '}'], '', $matches[0]);
            $parseStr .= '$__PID__ = ' . $varName . '; ';
        } else if(is_numeric($pidStr)){
            $parseStr .= '$__PID__ = ' . $pidStr . '; ';
        } else {
            $parseStr .= '$__PID__ = "' . $pidStr . '"; ';
        }

        // 将限制数量、排序和偏移量作为变量传递
        $parseStr .= '$__LIMIT__ = ' . $limit . '; ';
        $parseStr .= '$__ORDER__ = "' . $order . '"; '; // 添加排序变量
        $parseStr .= '$__OFFSET__ = ' . $offset . '; '; // 添加偏移量变量

        // 添加函数是否存在的检查，避免重复声明
        $parseStr .= '
        if (!function_exists("getAllChildCategories")) {
            function getAllChildCategories($parentId, $limit, $orderBy, $offset) {
                $navs = \\think\\facade\\Db::name("category")
                    ->where("pid", $parentId)
                    ->where("status", 1)
                    ->limit($offset, $limit) // 使用参数化的offset和limit
                    ->order($orderBy) // 使用参数化的order
                    ->select()->toArray();
                    
                foreach ($navs as &$nav) {
                    // 如果设置了外链，link 等于 outlink
                    if (!empty($nav["outlink"])) {
                        $nav["link"] = $nav["outlink"];
                    }
                    // 获取子分类，传递所有参数
                    $nav["nav"] = getAllChildCategories($nav["id"], $limit, $orderBy, $offset);
                }
                
                return $navs;
            }
        }
        
        // 获取分类列表，传递所有参数
        $__CATEGORY_LIST__ = getAllChildCategories($__PID__, $__LIMIT__, $__ORDER__, $__OFFSET__);
        ';

        // 循环输出
        $parseStr .= 'if(!empty($__CATEGORY_LIST__)): foreach($__CATEGORY_LIST__ as $key => $vo): $i = $key + 1; ?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; endif; ?>';

        return $parseStr;
    }

    //列表内容处理（添加分页支持）
    public function tagList($tag,$content)
    {
        // 标签模板格式
        $parseStr='<?php ';
        
        // 判断是否指定了scode
        $hasSpecificScode = isset($tag['scode']) && $tag['scode'] !== "";
        
        // 获取栏目ID - 如果未指定或为空字符串则尝试从当前页面获取
        if($hasSpecificScode){ 
            $scodeStr=trim($tag['scode']);
            
            // 处理变量形式的scode
            if(preg_match('/^\{?\$(.*)\}?$/',$scodeStr,$matches)){
                $varName=str_replace(['{','}'],'',$matches[0]);
                $parseStr.='$__SCODE__='.$varName.'; ';
            }else if(is_numeric($scodeStr)){
                $parseStr.='$__SCODE__='.$scodeStr.'; ';
            }else{
                $parseStr.='$__SCODE__="'.$scodeStr.'"; ';
            }
        }else{
            // 未指定scode，仅从$sort["id"]获取
            $parseStr.='
            if(isset($sort) && isset($sort["id"])){
                $__SCODE__=$sort["id"];
            }else{
                $__SCODE__=0;
            }';
        }
        
        // 获取每页显示数量
        $limit=isset($tag['num'])?intval($tag['num']):10;
        
        // 获取排序方式
        $order=isset($tag['order'])?$tag['order']:'sort asc,id desc';
        
        // 获取偏移量，并确保其为整数
        $offset=isset($tag['offset'])?intval($tag['offset']):0;
        
        // 递归获取子分类函数
        $parseStr.='
        if(!function_exists("getAllChildIds")){
            function getAllChildIds($parentId, $parentModel = null){
                // 如果没有传入父模型，先获取父分类的模型
                if($parentModel === null) {
                    $parentInfo = \\think\\facade\\Db::name("category")->where("id", $parentId)->find();
                    $parentModel = $parentInfo ? $parentInfo["model"] : null;
                }
                
                $result=[$parentId];
                
                // 获取子分类时，限制只获取相同模型的
                $whereConditions = [
                    ["pid", "=", $parentId],
                    ["status", "=", 1]
                ];
                
                // 如果有模型限制，则添加模型条件
                if($parentModel !== null) {
                    $whereConditions[] = ["model", "=", $parentModel];
                }
                
                $children=\\think\\facade\\Db::name("category")
                    ->where($whereConditions)
                    ->field("id")
                    ->select()->toArray();
                    
                foreach($children as $child){
                    $result=array_merge($result,getAllChildIds($child["id"], $parentModel));
                }
                return $result;
            }
        }
        
        $__CATE__=\\think\\facade\\Db::name("category")->where("id",$__SCODE__)->find();
        
        if($__CATE__){
            // 传入当前栏目的模型参数，确保只获取同模型下的子分类
            $__CATEGORY_IDS__=getAllChildIds($__SCODE__, $__CATE__["model"]);
            $__CATEGORY_IDS_STR__=implode(",",$__CATEGORY_IDS__);
            ';
        
        if($hasSpecificScode){
            // 指定了scode - 固定显示，完全不受任何分页影响
            $parseStr.='
            // 固定显示指定栏目内容，完全不受分页影响
            $__LIST__ = \\think\\facade\\Db::name("content")
                ->where("scode", "in", $__CATEGORY_IDS_STR__)
                ->where("status", 1)
                ->order("'.$order.'")
                ->limit('.$offset.', '.$limit.')
                ->select()
                ->toArray();
                
            $list = ""; // 不生成分页HTML
            ';
        }else{
            // 未指定scode - 正常分页显示，从当前栏目获取内容
            $parseStr.='
            // 获取当前页码 - 优先从变量中获取，但只对当前栏目有效
            $__CURRENT_PAGE__ = isset($current_page) ? $current_page : (\\think\\facade\\Request::param("page/d", 1));
            
            // 获取内容总数
            $__TOTAL_ITEMS__ = \\think\\facade\\Db::name("content")
                ->where("scode", "in", $__CATEGORY_IDS_STR__)
                ->where("status", 1)
                ->count();
                
            // 计算总页数
            $__TOTAL_PAGES__ = ceil($__TOTAL_ITEMS__ / '.$limit.');
            
            // 计算偏移量
            $__OFFSET__ = ($__CURRENT_PAGE__ - 1) * '.$limit.';
            
            // 获取当前页内容
            $__LIST__ = \\think\\facade\\Db::name("content")
                ->where("scode", "in", $__CATEGORY_IDS_STR__)
                ->where("status", 1)
                ->order("'.$order.'")
                ->limit($__OFFSET__, '.$limit.')
                ->select()
                ->toArray();
                
            // 生成自定义分页HTML - 生成静态HTML链接
            $__PAGE_HTML__ = "";
            
            // 始终显示分页，即使只有一页
            if($__TOTAL_PAGES__ >= 1) {
                // 获取当前栏目路径
                $__CURRENT_PATH__ = "";
                if(!empty($__CATE__["filename"])) {
                    $__CURRENT_PATH__ = trim($__CATE__["filename"], " \t\n\r\0\x0B/");
                } else if(!empty($__CATE__["link"])) {
                    $__CURRENT_PATH__ = trim($__CATE__["link"], " \t\n\r\0\x0B/");
                }

                $__PAGE_HTML__ = "<div class=\"page_nxt\">";

                // 首页 - 当前在第一页或只有一页时显示为禁用状态
                if($__CURRENT_PAGE__ == 1 || $__TOTAL_PAGES__ == 1) {
                    $__PAGE_HTML__ .= "<a class=\"disabled\" href=\"javascript:void(0);\">首页</a>";
                } else {
                    $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . "/\">首页</a>";
                }

                // 上一页（始终显示）
                if($__CURRENT_PAGE__ > 1) {
                    $prevPage = ($__CURRENT_PAGE__ == 2) ? "" : "_" . ($__CURRENT_PAGE__ - 1);
                    $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . $prevPage . "/\">上一页</a>";
                } else {
                    $__PAGE_HTML__ .= "<a class=\"disabled\" href=\"javascript:void(0);\">上一页</a>";
                }

                // 页码链接
                $__START_PAGE__ = max(1, $__CURRENT_PAGE__ - 2);
                $__END_PAGE__ = min($__TOTAL_PAGES__, $__CURRENT_PAGE__ + 2);

                for($__I__ = $__START_PAGE__; $__I__ <= $__END_PAGE__; $__I__++) {
                    if($__I__ == $__CURRENT_PAGE__) {
                        $__PAGE_HTML__ .= "<a class=\"current\">" . $__I__ . "</a>";
                    } else if($__I__ == 1) {
                        $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . "/\">" . $__I__ . "</a>";
                    } else {
                        $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . "_" . $__I__ . "/\">" . $__I__ . "</a>";
                    }
                }

                // 下一页（始终显示）
                if($__CURRENT_PAGE__ < $__TOTAL_PAGES__) {
                    $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . "_" . ($__CURRENT_PAGE__ + 1) . "/\">下一页</a>";
                } else {
                    $__PAGE_HTML__ .= "<a class=\"disabled\" href=\"javascript:void(0);\">下一页</a>";
                }

                // 末页 - 当前在最后一页或只有一页时显示为禁用状态
                if($__CURRENT_PAGE__ == $__TOTAL_PAGES__ || $__TOTAL_PAGES__ == 1) {
                    $__PAGE_HTML__ .= "<a class=\"disabled\" href=\"javascript:void(0);\">末页</a>";
                } else {
                    $__PAGE_HTML__ .= "<a href=\"/" . $__CURRENT_PATH__ . "_" . $__TOTAL_PAGES__ . "/\">末页</a>";
                }

                $__PAGE_HTML__ .= "</div>";
            }
            
            // 将分页HTML赋值给变量list
            $list = $__PAGE_HTML__;
            ';
        }
        
        $parseStr.='
            // 为每个内容项添加详情链接并获取扩展字段
            foreach($__LIST__ as &$__ITEM__){
                // 如果设置了外链，link 等于 outlink
                if (!empty($__ITEM__["outlink"])) {
                    $__ITEM__["link"] = $__ITEM__["outlink"];
                }

                // 查询content_ext表获取扩展字段
                $__CONTENT_EXT__ = \\think\\facade\\Db::name("content_ext")
                    ->where("content", $__ITEM__["id"])
                    ->select()->toArray();
                    
                // 转换为以field为键名，value为值的关联数组
                $__ITEM__["ext"] = array_column($__CONTENT_EXT__, "value", "field");
            }
        }else{
            $__LIST__=[];
            $list="";
        }
        ';
        
        // 循环输出内容
        $parseStr.='$i=0;';
        $parseStr.='foreach($__LIST__ as $key=>$vo):$i++;?>';
        $parseStr.=$content;
        $parseStr.='<?php endforeach;?>';
        
        return $parseStr;
    }
    

    //轮播处理
    public function tagBanner($tag,$content)
    {
        // 获取分组gid
        $gid=$tag['gid'];
        
        // 获取限制数量，并确保其为整数
        $limit=isset($tag['num'])?intval($tag['num']):10; // 转换为整数，默认10条
        
        // 获取排序方式
        $order=isset($tag['order'])?$tag['order']:'sort asc,id asc'; // 默认排序方式
        
        // 获取偏移量，并确保其为整数
        $offset=isset($tag['offset'])?intval($tag['offset']):0; // 默认偏移量为0
        
        // 标签模板格式
        $parseStr='<?php ';
        $parseStr.='$__LIST__=\\think\\facade\\Db::name("banner")->where("gid","'.$gid.'")->order("'.$order.'")->limit('.$offset.','.$limit.')->select();';
        $parseStr.='$i=0;';
        $parseStr.='foreach($__LIST__ as $key=>$vo):$i++;?>';
        $parseStr.=$content;
        $parseStr.='<?php endforeach;?>';
        
        return $parseStr;
    }

    //友链处理
    public function tagLink($tag,$content)
    {
        // 获取分组gid
        $gid=$tag['gid'];
        
        // 获取限制数量，并确保其为整数
        $limit=isset($tag['num'])?intval($tag['num']):10; // 转换为整数，默认10条
        
        // 获取排序方式
        $order=isset($tag['order'])?$tag['order']:'sort asc,id asc'; // 默认排序方式
        
        // 获取偏移量，并确保其为整数
        $offset=isset($tag['offset'])?intval($tag['offset']):0; // 默认偏移量为0
        
        // 标签模板格式
        $parseStr='<?php ';
        $parseStr.='$__LIST__=\\think\\facade\\Db::name("link")->where("gid","'.$gid.'")->order("'.$order.'")->limit('.$offset.','.$limit.')->select();';
        $parseStr.='$i=0;';
        $parseStr.='foreach($__LIST__ as $key=>$vo):$i++;?>';
        $parseStr.=$content;
        $parseStr.='<?php endforeach;?>';
        
        return $parseStr;
    }
    
    //栏目内容处理和单页处理
    public function tagContent($tag,$content)
    {
        // 标签模板格式
        $parseStr='<?php ';
        
        // 判断是否提供了id参数
        if(isset($tag['id'])){
            // 获取分类ID
            $id=$tag['id'];
            // 从category表获取数据
            $parseStr.='$__LIST__=\\think\\facade\\Db::name("category")->where("id","'.$id.'")->find();';
        }
        // 判断是否提供了scode参数
        else if(isset($tag['scode'])){
            // 获取栏目scode
            $scode=$tag['scode'];
            // 从single表获取数据
            $parseStr.='$__LIST__=\\think\\facade\\Db::name("single")->where("scode","'.$scode.'")->find();';
        }

        // 判断结果并输出内容
        $parseStr.='if($__LIST__):$vo=$__LIST__;?>';
        $parseStr.=$content;
        $parseStr.='<?php endif;?>';
        
        return $parseStr;
    }

    // 多图处理
    public function tagPics($tag, $content)
    {
        // 获取分组id
        $id = isset($tag['id']) ? $tag['id'] : 0;

        // 获取限制数量，并确保其为整数
        $limit = isset($tag['num']) ? intval($tag['num']) : 10; // 转换为整数，默认10条

        // 获取偏移量，并确保其为整数
        $offset = isset($tag['offset']) ? intval($tag['offset']) : 0; // 默认偏移量为0

        // 标签模板格式
        $parseStr = '<?php ';
        $parseStr .= '$__CONTENT__ = \\think\\facade\\Db::name("content")->where("id", ' . $id . ')->find();';
        $parseStr .= 'if ($__CONTENT__ && !empty($__CONTENT__["pics"])) {';
        $parseStr .= '    $__PICS__ = explode(",", $__CONTENT__["pics"]);';
        $parseStr .= '    $__PICS__ = array_slice($__PICS__, ' . $offset . ', ' . $limit . ');';
        $parseStr .= '    $i = 0;';
        $parseStr .= '    foreach($__PICS__ as $key => $vo): $i++;';
        $parseStr .= '?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; } ?>';

        return $parseStr;
    }

    // 标签处理
    public function tagTags($tag, $content)
    {
        // 获取分组id
        $id = isset($tag['id']) ? $tag['id'] : 0;

        // 获取限制数量，并确保其为整数
        $limit = isset($tag['num']) ? intval($tag['num']) : 10; // 转换为整数，默认10条

        // 获取偏移量，并确保其为整数
        $offset = isset($tag['offset']) ? intval($tag['offset']) : 0; // 默认偏移量为0

        // 标签模板格式
        $parseStr = '<?php ';
        $parseStr .= '$__CONTENT__ = \\think\\facade\\Db::name("content")->where("id", ' . $id . ')->find();';
        $parseStr .= 'if ($__CONTENT__ && !empty($__CONTENT__["tags"])) {';
        $parseStr .= '    $__TAGS__ = explode(",", $__CONTENT__["tags"]);';
        $parseStr .= '    $__TAGS__ = array_slice($__TAGS__, ' . $offset . ', ' . $limit . ');';
        $parseStr .= '    $i = 0;';
        $parseStr .= '    foreach($__TAGS__ as $key => $vo): $i++;';
        $parseStr .= '?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; } ?>';

        return $parseStr;
    }

    // 搜索处理（支持分页）
    public function tagSearch($tag, $content)
    {
        // 获取限制数量，并确保其为整数
        $limit = isset($tag['num']) ? intval($tag['num']) : 10; // 默认10条每页

        // 获取排序方式
        $order=isset($tag['order'])?$tag['order']:'sort asc,id desc'; // 默认排序方式

        // 获取搜索关键字
        $keyword = Request::param('keyword');

        // 配置参数
        $config = Db::name('config')->where('id', 1)->find();
        $model = explode(',', $config['search']);
        
        // 标签模板格式
        $parseStr = '<?php ';
        $parseStr .= '$__SEARCH__ = [];';
        $parseStr .= '$list = "";'; // 分页HTML

        $parseStr .= 'if (!empty($keyword)) {';
        $parseStr .= '    $__PAGINATOR__ = \\think\\facade\\Db::name("content")';
        $parseStr .= '        ->where("title", "like", "%" . $keyword . "%")';
        $parseStr .= '        ->where("status", 1)';
        $parseStr .= '        ->whereIn("model", ' . var_export($model, true) . ')';
        $parseStr .= '        ->order("' . $order . '")';
        $parseStr .= '        ->paginate([';
        $parseStr .= '            "list_rows" => ' . $limit . ',';
        $parseStr .= '            "query" => request()->param(),';
        $parseStr .= '        ]);';
        $parseStr .= '    $__SEARCH__ = $__PAGINATOR__->items();';
        
        // 自定义分页HTML格式
        $parseStr .= '    $__CURRENT_PAGE__ = $__PAGINATOR__->currentPage();';
        $parseStr .= '    $__TOTAL_PAGES__ = $__PAGINATOR__->lastPage();';
        $parseStr .= '    $__BASE_URL__ = "/search";';
        $parseStr .= '    $__KEYWORD__ = urlencode($keyword);';
        
        $parseStr .= '    $list = "";';
        $parseStr .= '    if($__TOTAL_PAGES__ >= 1) {';
        $parseStr .= '        $list = "<div class=\"page_nxt\">";';
        
        // 首页 - 当前在第一页或只有一页时显示为禁用状态
        $parseStr .= '        if($__CURRENT_PAGE__ == 1 || $__TOTAL_PAGES__ == 1) {';
        $parseStr .= '            $list .= "<a class=\"disabled\" href=\"javascript:void(0);\">首页</a>";';
        $parseStr .= '        } else {';
        $parseStr .= '            $list .= "<a href=\"" . $__BASE_URL__ . "?keyword=" . $__KEYWORD__ . "&page=1\">首页</a>";';
        $parseStr .= '        }';
        
        // 上一页
        $parseStr .= '        if($__CURRENT_PAGE__ > 1) {';
        $parseStr .= '            $prevPage = $__CURRENT_PAGE__ - 1;';
        $parseStr .= '            $list .= "<a href=\"" . $__BASE_URL__ . "?keyword=" . $__KEYWORD__ . "&page=" . $prevPage . "\">上一页</a>";';
        $parseStr .= '        } else {';
        $parseStr .= '            $list .= "<a class=\"disabled\" href=\"javascript:void(0);\">上一页</a>";';
        $parseStr .= '        }';
        
        // 页码链接
        $parseStr .= '        $__START_PAGE__ = max(1, $__CURRENT_PAGE__ - 2);';
        $parseStr .= '        $__END_PAGE__ = min($__TOTAL_PAGES__, $__CURRENT_PAGE__ + 2);';
        $parseStr .= '        for($__I__ = $__START_PAGE__; $__I__ <= $__END_PAGE__; $__I__++) {';
        $parseStr .= '            if($__I__ == $__CURRENT_PAGE__) {';
        $parseStr .= '                $list .= "<a class=\"current\">" . $__I__ . "</a>";';
        $parseStr .= '            } else {';
        $parseStr .= '                $list .= "<a href=\"" . $__BASE_URL__ . "?keyword=" . $__KEYWORD__ . "&page=" . $__I__ . "\">" . $__I__ . "</a>";';
        $parseStr .= '            }';
        $parseStr .= '        }';
        
        // 下一页
        $parseStr .= '        if($__CURRENT_PAGE__ < $__TOTAL_PAGES__) {';
        $parseStr .= '            $nextPage = $__CURRENT_PAGE__ + 1;';
        $parseStr .= '            $list .= "<a href=\"" . $__BASE_URL__ . "?keyword=" . $__KEYWORD__ . "&page=" . $nextPage . "\">下一页</a>";';
        $parseStr .= '        } else {';
        $parseStr .= '            $list .= "<a class=\"disabled\" href=\"javascript:void(0);\">下一页</a>";';
        $parseStr .= '        }';
        
        // 末页 - 当前在最后一页或只有一页时显示为禁用状态
        $parseStr .= '        if($__CURRENT_PAGE__ == $__TOTAL_PAGES__ || $__TOTAL_PAGES__ == 1) {';
        $parseStr .= '            $list .= "<a class=\"disabled\" href=\"javascript:void(0);\">末页</a>";';
        $parseStr .= '        } else {';
        $parseStr .= '            $list .= "<a href=\"" . $__BASE_URL__ . "?keyword=" . $__KEYWORD__ . "&page=" . $__TOTAL_PAGES__ . "\">末页</a>";';
        $parseStr .= '        }';
        
        $parseStr .= '        $list .= "</div>";';
        $parseStr .= '    }';

        // 为每个搜索结果添加详情链接
        $parseStr .= '    foreach ($__SEARCH__ as &$__ITEM__) {';
        $parseStr .= '        if (!empty($__ITEM__["outlink"])) {';
        $parseStr .= '            $__ITEM__["link"] = $__ITEM__["outlink"];'; // 如果设置了外链，link 等于 outlink
        $parseStr .= '        }';
        $parseStr .= '    }';
        $parseStr .= '}';
        $parseStr .= '$i = 0;';
        $parseStr .= 'foreach ($__SEARCH__ as $key => $vo): $i++; ?>';
        $parseStr .= $content;
        $parseStr .= '<?php endforeach; ?>';

        return $parseStr;
    }

}
