<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class User extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        if (!$this->hasPermission('user_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function add()
    {
        if (!$this->hasPermission('user_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        return View::fetch('add');
    }

    public function create()
    {
        if (!$this->hasPermission('user_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        return View::fetch('add');
    }

    public function getuser(Request $request)
    {
        if (!$this->hasPermission('user_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('limit')?$request->param('limit'):10;
        $builder = Db::name('user');
        if ($request->param('searchParams')) {
            $searchParams = json_decode($request->param('searchParams'));
            $builder->where('username', 'like', '%' .$searchParams->username . '%');
        }
        $table = $builder->order('id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        if (!$this->hasPermission('user_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data=input('post.');
        $data['username'] = trim($data['username']);
        $data['time']=time();
        $userId = Db::name('user')->strict(false)->insertGetId($data);
        if($userId){
            $username = isset($data['username']) ? $data['username'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : '';
            $this->logAction('添加会员列表，ID:' . $userId . '，用户名:' . $username . '，状态:' . $statusText);
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        if (!$this->hasPermission('user_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑权限！</div>';
        }
        $edit=Db::name('user')->find($id);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        if (!$this->hasPermission('user_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $data['username'] = trim($data['username']);
        $id=$data['id'];
        // 获取数据库中的原始数据
        $originalData = Db::name('user')->where('id',$id)->find();
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何更新']);
        }
        $user=Db::name('user')->where(['id'=>$data['id']])->strict(false)->save($data);
        if($user){
            $username = isset($data['username']) ? $data['username'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : '';
            $this->logAction('编辑会员列表，ID:' . $data['id'] . '，用户名:' . $username . '，状态:' . $statusText);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }


    public function click()
    {
        if (!$this->hasPermission('user_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        Db::name('user')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        $user = Db::name('user')->where(['id'=>$data['id']])->find();
        $username = isset($user['username']) ? $user['username'] : '';
        $this->logAction('更新用户字段，ID:' . $data['id'] . '，用户名:' . $username . '，字段:' . $data['field'] . '，值:' . $data['value']);
    }


    public function status(Request $request)
    {
        if (!$this->hasPermission('user_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $user = Db::name('user')->where('id', $id)->find();
        $username = isset($user['username']) ? $user['username'] : '';
        if($status){
            Db::name('user')->where('id',$id)->update(['status'=>0]);
            $this->logAction('更新会员列表，ID:' . $id . '，用户名:' . $username . '，状态:禁用');
        }else{
            Db::name('user')->where('id',$id)->update(['status'=>1]);
            $this->logAction('更新会员列表，ID:' . $id . '，用户名:' . $username . '，状态:启用');
        }
    }

    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        if (!$this->hasPermission('user_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $user = Db::name('user')->where('id', $id)->find();
        $username = isset($user['username']) ? $user['username'] : '';
        $res = Db::name('user')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除会员列表，ID:' . $id . '，用户名:' . $username);
        	return json(['status'=>'success','msg'=>'删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        if (!$this->hasPermission('user_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $usernames = [];
        if (is_array($ids)) {
            $users = Db::name('user')->where('id', 'in', $ids)->column('username', 'id');
            foreach ($ids as $id) {
                $usernames[] = isset($users[$id]) ? $users[$id] : '';
            }
        } else {
            $user = Db::name('user')->where('id', $ids)->find();
            $usernames[] = isset($user['username']) ? $user['username'] : '';
        }
        $del= Db::name('user')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除会员列表，ID:' . json_encode($ids, JSON_UNESCAPED_UNICODE) . '，用户名:' . json_encode($usernames, JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
