<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Msg extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index(Request $request)
    {
        // 权限判断：浏览
        if (!$this->hasPermission('msg_view')) {
            return '<div style="color:red;text-align:center;margin:60px auto;font-size:18px;">无权限访问留言信息</div>';
        }
        // ...existing code...
        // 获取当前页码并转换为整数
        $page = (int) $request->param('page', 1);
        // 每页显示的记录数并转换为整数
        $limit = (int) $request->param('limit', 10);

        // 获取表单数据
        $msg = Db::name('msg')->where('form_id', 1)->order('sign desc,id asc')->select()->toArray();

        // 按照 sign 分组
        $groupedMsg = [];
        foreach ($msg as $item) {
            $groupedMsg[$item['sign']][] = $item;
        }

        // 获取总记录数
        $total = count($groupedMsg);
       
        // 分页处理
        $groupedMsg = array_slice($groupedMsg, ($page - 1) * $limit, $limit);

        View::assign([
            'groupedMsg' => $groupedMsg,
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
        ]);

        return View::fetch('index');
    }

    
    
   
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete()
    {
        // 权限判断：删除
        if (!$this->hasPermission('msg_delete')) {
            return json(['status'=>'fail','msg'=>'无权限清空']);
        }
        $data=input('post.');
        $res = Db::name('msg')->where(['sign'=>$data['sign']])->delete();
        if($res){
            $this->logAction('清空留言，sign:' . $data['sign']);
            return json(['status'=>'success','msg'=>'清空成功']);
        }else{
            return json(['status'=>'fail','msg'=>'清空失败']);
        }
    }
    
    public function del()
    {
        // 权限判断：删除
        if (!$this->hasPermission('msg_delete')) {
            return json(['status'=>'fail','msg'=>'无权限清空']);
        }
        $data=input('post.');
        $del = Db::name('msg')->where(['sign'=>$data['signs']])->delete();
        if($del){
            $this->logAction('批量清空留言，signs:' . json_encode($data['signs']));
            return json(['status'=>'success','msg'=>'批量清空成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量清空失败']);
        }
    }

    public function clearAll()
    {
        // 权限判断：删除
        if (!$this->hasPermission('msg_delete')) {
            return json(['status'=>'fail','msg'=>'无权限清空']);
        }
        Db::name('msg')->where('form_id', 1)->delete();
        $this->logAction('全部清空留言，form_id:1');
        return json(['status' => 'success', 'msg' => '清空成功']);
    }
}
