<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Model extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        // 权限拦截：查看权限
        if (!$this->hasPermission('model_view')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限查看模型']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问模型管理权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function add()
    {
        return View::fetch('add');
    }

    public function create()
    {
        $dir = 'template/index';
        $files = scandir($dir);
        // 使用 array_filter 和闭包函数
        $template = array_filter($files, function($item) {
            // 检查元素是否以 ".com" 后缀结束
            return substr($item, -5) === '.html';
        });
        View::assign([
            'template'=>$template,
        ]);
        return View::fetch('add');
    }

    public function getmodel(Request $request)
    {
       
        $limit = $request->param('limit')?$request->param('limit'):10;
        $table =Db::name('model')->order('sort asc,id asc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
        
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        // 权限拦截：添加权限
        if (!$this->hasPermission('model_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加模型']);
        }
        $data=input('post.');

        // 检查 URL 名称是否合法
        if ($data['url'] && !preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['url'])) {
            return json(['msg' => 'URL名称只允许字母、数字、横线、斜线组成', 'status' => 'fail']);
        }


        $article=Db::name('model')->insert($data);
        if($article){
                $name = isset($data['name']) ? $data['name'] : '';
                $id = Db::name('model')->getLastInsID();
                $this->logAction('添加模型管理，ID:' . $id . '，模型名称:' . $name);
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    public function field($id)
    {
       
        $field=Db::name('model')->find($id);

        
        View::assign([
            'field'=>$field,
        ]);
        return View::fetch('field');
    }


    public function getfield(Request $request)
    {
        
        $limit = $request->param('limit')?$request->param('limit'):10;
        $model=$request->param('model');
        $builder = Db::name('extfield')->where('model',$model)->field('a.*,b.name')->alias('a')->join('model b','a.model=b.id');
        $table =$builder->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }
    

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        $dir = 'template/index';
        $files = scandir($dir);
        // 使用 array_filter 和闭包函数
        $template = array_filter($files, function($item) {
            // 检查元素是否以 ".com" 后缀结束
            return substr($item, -5) === '.html';
        });
        // 权限拦截：编辑权限
        if (!$this->hasPermission('model_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑模型']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑模型权限！</div>';
        }
        $edit=Db::name('model')->find($id);
        View::assign([
            'edit'=>$edit,
            'template'=>$template,
        ]);
        return View::fetch('edit');
    }



    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('model_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑模型']);
        }
        $data=input('post.');
        $id=$data['id'];
        // 检查 URL 名称是否合法
        if ($data['url'] && !preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['url'])) {
            return json(['msg' => 'URL名称只允许字母、数字、横线、斜线组成', 'status' => 'fail']);
        }
        

        // 获取数据库中的原始数据
        $originalData = Db::name('model')->where('id', $id)->find();

        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }

        $model=Db::name('model')->where(['id'=>$data['id']])->save($data);
        if($model){
                $name = isset($data['name']) ? $data['name'] : '';
                $this->logAction('编辑模型管理，ID:' . $data['id'] . '，模型名称:' . $name);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }


    public function click()
    {
        $data=input('post.');
        $model = Db::name('model')->where(['id'=>$data['id']])->find();
        Db::name('model')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        $name = isset($model['name']) ? $model['name'] : '';
        $this->logAction('修改模型字段，ID:' . $data['id'] . '，模型名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);
    }



   

    public function status(Request $request)
    {
        if (!$this->hasPermission('model_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $model = Db::name('model')->where('id', $id)->find();
        $name = isset($model['name']) ? $model['name'] : '';
        $res = Db::name('model')->where('id', $id)->update(['status' => $status]);
        $statusText = $status == 1 ? '显示' : '隐藏';
        if($res !== false){
            $this->logAction('更新模型状态，ID:' . $id . '，模型名称:' . $name . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }

	}


    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {

        // 权限拦截：删除权限
        if (!$this->hasPermission('model_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除模型']);
        }
        $category=Db::name('category')->where('model',$id)->find();
        if($category){
            return json(['status'=>'fail','msg'=>'模型下面有栏目，不允许直接删除']);
        }else{
            $model=Db::name('model')->find($id);
            Db::name('extfield')->where('model',$id)->delete();
            Db::name('content')->where('model',$id)->delete();
            Db::name('content_ext')->where('model',$id)->delete();
            Db::name('single')->where('model',$id)->delete();
            Db::name('single_ext')->where('model',$id)->delete();
            $res = Db::name('model')->where('id',$id)->delete();
            if($res){
                    $name = isset($model['name']) ? $model['name'] : '';
                    $this->logAction('删除模型管理，ID:' . $id . '，模型名称:' . $name);
                return json(['status'=>'success','msg'=>'删除成功']);
            }else{
                return json(['status'=>'fail','msg'=>'删除失败']);
            }
        }

        
    }
    
    public function del()
    {
        // 权限拦截：批量删除权限
        if (!$this->hasPermission('model_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除模型']);
        }
        $data=input('post.');
        $ids=$data['id'];
            $names = [];
            if (is_array($ids)) {
                $models = Db::name('model')->where('id', 'in', $ids)->column('name', 'id');
                foreach ($ids as $id) {
                    $names[] = isset($models[$id]) ? $models[$id] : '';
                }
            } else {
                $model = Db::name('model')->where('id', $ids)->find();
                $names[] = isset($model['name']) ? $model['name'] : '';
            }
        foreach($ids as $k=>$v){
            Db::name('extfield')->where('model',$v)->delete();
            Db::name('content')->where('model',$v)->delete();
            Db::name('content_ext')->where('model',$v)->delete();
            Db::name('single')->where('model',$v)->delete();
            Db::name('single_ext')->where('model',$v)->delete();
        }
        $del= Db::name('model')->where(['id'=>$data['id']])->delete();
        if($del){
                $this->logAction('批量删除模型管理，ID:' . json_encode($ids) . '，模型名称:' . json_encode($names, JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
