<?php
declare (strict_types = 1);

namespace app\admin\controller;
use think\facade\View;
use think\facade\Db;


class Login
{

    /**
     * 记录操作日志
     * @param string $event 事件内容（如：登录成功、登录失败）
     */
    public function logAction($event)
    {
        $adname = session('adname');
        $username = is_array($adname) ? ($adname['adname'] ?? '') : $adname;
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $os = $this->getOS($userAgent);
        $browser = $this->getBrowser($userAgent);
        $time = date('Y-m-d H:i:s');
        
        $data = [
            'username' => $username,
            'time' => $time,
            'event' => $event,
            'os' => $os,
            'browser' => $browser,
            'ip' => $ip
        ];
        try {
            Db::name('log')->strict(false)->insert($data);
        } catch (\Throwable $e) {
            // 可选：写入文件或忽略
        }
    }


    public function index()
    {
        //允许的访问方式
        $config = Db::name('config')->where('id', 1)->find();
        $query = isset($_SERVER['QUERY_STRING']) ? strtolower($_SERVER['QUERY_STRING']) : '';
        $uri   = isset($_SERVER['REQUEST_URI']) ? strtolower($_SERVER['REQUEST_URI']) : '';

        if (strpos($uri, '/admin/login') !== false) {
            return View::fetch('404.html');
        }
       
        //判断当前是否已登录过后台
        $adname =session('adname');
         // 站点信息
        $system=Db::name('system')->where('id',1)->find();
      
       
        if($adname==!null){
            echo '<script>window.location.href="/' . $config['admin_path'] . '.php"</script>';
            exit;
        }

        View::assign([
            'system'=>$system,
            'config'=>$config,
        ]);
        
        return View::fetch('index');
    }

    public function login()
    {
        $data=input('post.');
        $config = Db::name('config')->where('id', 1)->find();
        if($config['code'] != 0) {
            if(!captcha_check($data['captcha'])) {
                return json(['status' => 'fail', 'msg' => '验证码错误']);
            }
        }
        $admin=Db::name('admin')->where(['adname'=>$data['adname'],'password'=>md5($data['password'])])->find();
        if($admin){
            if($admin['status'] == 0){
                $this->logAction('登录失败（用户被禁用）：' . $data['adname']);
                return json(['status'=>'fail','msg'=>'用户已被禁用，请联系管理员！']);
            }
            session('adname', $admin);
            session('admin_id', $admin['id']);
            $this->logAction('登录成功：' . $data['adname']);
            return json(['status'=>'success','msg'=>'登录成功！']);
        }else{
            $this->logAction('登录失败（用户名或密码错误）：' . $data['adname']);
            return json(['status'=>'fail','msg'=>'用户名或密码错误！']);
        }
    }

    public function logout()
    {
        session(null);
        return json(['status'=>'success','msg'=>'退出成功！']);
    }

    // 获取浏览器信息
    public function getBrowser($userAgent)
    {
        if (strpos($userAgent, 'MSIE') !== false || strpos($userAgent, 'Trident') !== false) {
            return 'Internet Explorer';
        } elseif (strpos($userAgent, 'Firefox') !== false) {
            return 'Firefox';
        } elseif (strpos($userAgent, 'Chrome') !== false) {
            return 'Chrome';
        } elseif (strpos($userAgent, 'Safari') !== false) {
            return 'Safari';
        } elseif (strpos($userAgent, 'Opera') !== false || strpos($userAgent, 'OPR') !== false) {
            return 'Opera';
        } else {
            return 'Other';
        }
    }

    // 获取操作系统信息
    public function getOS($userAgent)
    {
        if (preg_match('/Windows NT 10.0/i', $userAgent)) {
            return 'Windows 10';
        } elseif (preg_match('/Windows NT 6.3/i', $userAgent)) {
            return 'Windows 8.1';
        } elseif (preg_match('/Windows NT 6.2/i', $userAgent)) {
            return 'Windows 8';
        } elseif (preg_match('/Windows NT 6.1/i', $userAgent)) {
            return 'Windows 7';
        } elseif (preg_match('/Windows NT 6.0/i', $userAgent)) {
            return 'Windows Vista';
        } elseif (preg_match('/Windows NT 5.1/i', $userAgent)) {
            return 'Windows XP';
        } elseif (preg_match('/Mac OS X/i', $userAgent)) {
            return 'Mac OS X';
        } elseif (preg_match('/Linux/i', $userAgent)) {
            return 'Linux';
        } elseif (preg_match('/iPhone/i', $userAgent)) {
            return 'iPhone';
        } elseif (preg_match('/iPad/i', $userAgent)) {
            return 'iPad';
        } elseif (preg_match('/Android/i', $userAgent)) {
            return 'Android';
        } else {
            return 'Other';
        }
    }

}
