<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Log extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        if (!$this->hasPermission('log_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        } else {
            return View::fetch('index');
        }
    }


    public function getlog(Request $request)
    {

        if (!$this->hasPermission('log_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('log')?$request->param('limit'):15;
        $table = Db::name('log')->order('id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }




    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function clear()
    {
        if (!$this->hasPermission('log_delete')) {
            return json(['status'=>'fail','msg'=>'无权限清空']);
        }
        $res = Db::name('log')->delete(true);
        if($res){
            $this->logAction('清空日志');
        	return json(['status'=>'success','msg'=>'清空成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'清空失败']);
        }
    }
    

}
