<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Link extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        if (!$this->hasPermission('link_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */


    public function create()
    {
        if (!$this->hasPermission('link_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        $gid=Db::name('link')->distinct(true)->field('gid')->order('gid asc')->select();
        View::assign([
            'gid'=>$gid
        ]);
        return View::fetch('add');
    }

    public function getlink(Request $request)
    {
        
        if (!$this->hasPermission('link_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('limit')?$request->param('limit'):10;
        $table = Db::name('link')->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        if (!$this->hasPermission('link_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data=input('post.');
        $data['time']=time();
        if($data['gid']==''){
            $count=Db::name('link')->count();
            if($count=='0'){
                $data['gid']='1';
            }else{
                $gid=Db::name('link')->where('status',1)->order('gid desc')->limit(1)->find();
                $data['gid']=$gid['gid'] + '1';
            }
        }
        $linkId = Db::name('link')->strict(false)->insertGetId($data);
        if($linkId){
            $name = isset($data['name']) ? $data['name'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '显示' : '隐藏') : '';
            $this->logAction('添加友情链接，ID:' . $linkId . '，名称:' . $name . '，状态:' . $statusText);
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

    

    /**
     * 显示更新资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        if (!$this->hasPermission('link_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限更新']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无更新权限！</div>';
        }
        $edit=Db::name('link')->find($id);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        if (!$this->hasPermission('link_edit')) {
            return json(['status'=>'fail','msg'=>'无权限更新']);
        }
        $data=input('post.');
        $id = $data['id'];
        // 获取数据库中的原始数据
        $originalData = Db::name('link')->where('id', $id)->find();
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }
        $link=Db::name('link')->strict(false)->where(['id'=>$data['id']])->save($data);
        if($link){
            $name = isset($data['name']) ? $data['name'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '显示' : '隐藏') : '';
            $this->logAction('更新友情链接，ID:' . $data['id'] . '，名称:' . $name . '，状态:' . $statusText);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }


    public function click()
    {
        if (!$this->hasPermission('link_edit')) {
            return json(['status'=>'fail','msg'=>'无权限更新']);
        }
        $data=input('post.');
        Db::name('link')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        $link = Db::name('link')->where(['id'=>$data['id']])->find();
        $name = isset($link['name']) ? $link['name'] : '';
        $this->logAction('修改友情链接字段，ID:' . $data['id'] . '，名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);
    }


    public function status(Request $request)
    {
        if (!$this->hasPermission('link_edit')) {
            return json(['status'=>'fail','msg'=>'无权限更新']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $res = Db::name('link')->where('id', $id)->update(['status' => $status]);
        if($res !== false){
            $link = Db::name('link')->where('id', $id)->find();
            $name = isset($link['name']) ? $link['name'] : '';
            $statusText = $status == 1 ? '显示' : '隐藏';
            $this->logAction('更新友情链接状态，ID:' . $id . '，名称:' . $name . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}

    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        if (!$this->hasPermission('link_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $link = Db::name('link')->where('id', $id)->find();
        $name = isset($link['name']) ? $link['name'] : '';
        $res = Db::name('link')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除友情链接，ID:' . $id . '，名称:' . $name);
            return json(['status'=>'success','msg'=>'删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        if (!$this->hasPermission('link_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $names = [];
        if (is_array($ids)) {
            $links = Db::name('link')->where('id', 'in', $ids)->column('name', 'id');
            foreach ($ids as $id) {
                $names[] = isset($links[$id]) ? $links[$id] : '';
            }
        } else {
            $link = Db::name('link')->where('id', $ids)->find();
            $names[] = isset($link['name']) ? $link['name'] : '';
        }
        $del= Db::name('link')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除友情链接，ID:' . json_encode($ids) . '，名称:' . json_encode($names));
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
