<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Extfield extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index($id)
    {
        $model=Db::name('model')->find($id);
        View::assign([
            'model'=>$model,
        ]);
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function add()
    {
        return View::fetch('add');
    }

    public function create()
    {
        $model=input('model');
        // 获取所有分类并生成树形结构
        $lst=Db::name('category')->order('id asc')->select();
        $lst=tree($lst);

        View::assign([
            'lst' => $lst,
            'model'=>$model,
        ]);
        return View::fetch('add');
        
        
    }

    public function getextfield(Request $request)
    {
        $limit = $request->param('limit')?$request->param('limit'):15;
        $model=$request->param('model');
        $builder = Db::name('extfield')->where('model',$model)->field('a.*,b.name')->alias('a')->join('model b','a.model=b.id');
        $table =$builder->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
        
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        $data=input('post.');
        
        if($data['field'] && ! preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['field'])) {
            return json(['msg'=>'字段名称只允许字母、数字、横线、斜线组成！','status'=>'fail']);
        }else{

            $ext='ext_';
            $data['field']=$ext.$data['field'];
            $data['appoint'] = implode(',', $data['appoint']);
            //如果appoint是0,则说明勾选的改模型所有的指定的栏目
            if($data['appoint']=='0'){
                $data['appoint']='';
                $category=Db::name('category')->where(['model'=>$data['model']])->select();
                foreach($category as $k=>$v){
                    $data['appoint'].=','.$v['id'];
                }
                //去除第一个逗号
                $data['appoint']=trim($data['appoint'],',');
            }else{
                // 如果 appoint 不等于 '0'，检查是否包含 0 并去掉
                $appointArray = explode(',', $data['appoint']); // 转换为数组
                $appointArray = array_filter($appointArray, function ($value) {
                    return $value !== '0'; // 过滤掉 0
                });
                $data['appoint'] = implode(',', $appointArray); // 转换回字符串
            }
            
            $content=Db::name('content')->where(['model'=>$data['model']])->select();
            foreach($content as $k=>$v){
                $appointArr = array_filter(explode(',', $data['appoint']));
                if (in_array($v['scode'], $appointArr)) {
                    Db::name('content_ext')->insert(['content'=>$v['id'],'model'=>$data['model'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                }
            }
           
            $single=Db::name('single')->where(['model'=>$data['model']])->select();
           
            foreach($single as $k=>$v){
                $appointArr = array_filter(explode(',', $data['appoint']));
                if (in_array($v['scode'], $appointArr)) {
                    Db::name('single_ext')->insert(['single'=>$v['id'],'model'=>$data['model'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                }
            }
         
            $extfield=Db::name('extfield')->where(['field'=>$data['field']])->find();
            if($extfield){
                return json(['msg'=>'字段名称已经存在，不能重复添加！','status'=>'fail']);
            }else{
                Db::name('extfield')->insert($data);
                $id = Db::name('extfield')->getLastInsID();
                $name = $data['field'];
                $model=Db::name('model')->where(['id'=>$data['model']])->find();
                $this->logAction('添加内容字段，ID:' . $id . '，字段名称:' . $name . '，模型名称:' . $model['name']);
                return json(['msg'=>'添加成功','status'=>'success']);
            }
        }
        
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        // 获取所有分类并生成树形结构
        $edit=Db::name('extfield')->find($id);
        $edit['field']=substr($edit['field'],4); // 去除前缀ext_//前四位字符
        $lst=Db::name('category')->order('id asc')->select();
        $lst=tree($lst);
        $appointArray = explode(',', $edit['appoint']);
        foreach ($lst as &$item) {
            if (in_array($item['id'], $appointArray)) {
                $item['selected'] = true; // 增加 selected 标记
            } else {
                $item['selected'] = false; // 未选中
            }
        }
        View::assign([
            'lst' => $lst,
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        $data=input('post.');
        $id=$data['id'];
        $ext='ext_';
        $data['field']=$ext.$data['field'];

        // 获取数据库中的原始数据
        $originalData = Db::name('extfield')->where('id', $id)->find();
        $data['appoint'] = implode(',', $data['appoint']);
        //如果appoint是0,则说明勾选的改模型所有的指定的栏目
        if($data['appoint']=='0'){
            $data['appoint']='';
            $category=Db::name('category')->where(['model'=>$originalData['model']])->select();
            foreach($category as $k=>$v){
                $data['appoint'].=','.$v['id'];
            }
            //去除第一个逗号
            $data['appoint']=trim($data['appoint'],',');
        }else{
            // 如果 appoint 不等于 '0'，检查是否包含 0 并去掉
            $appointArray = explode(',', $data['appoint']); // 转换为数组
            $appointArray = array_filter($appointArray, function ($value) {
                return $value !== '0'; // 过滤掉 0
            });
            $data['appoint'] = implode(',', $appointArray); // 转换回字符串
        }

     
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }

        if($data['field'] && ! preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['field'])) {
            return json(['msg'=>'字段名称只允许字母、数字、横线、斜线组成！','status'=>'fail']);
        }else{
            //原先字段情况
            $extfield=Db::name('extfield')->where(['field'=>$data['field']])->find();
            
            $save=Db::name('extfield')->where(['id'=>$data['id']])->save($data);
            $name = $data['field'];
            if($save){
                $model=Db::name('model')->where(['id'=>$data['model']])->find();
                $this->logAction('更新内容字段，ID:' . $data['id'] . '，字段名称:' . $name . '，模型名称:' . $model['name']);
                //如果修改了 指定栏目的情况
                if($extfield['appoint']!==$data['appoint']){
                    // 1. 转为数组
                    $newAppointArr = array_filter(explode(',', $data['appoint']));      // 新的栏目id数组
                    $oldAppointArr = array_filter(explode(',', $extfield['appoint']));  // 旧的栏目id数组

                    // 2. 计算新增和减少的栏目id
                    $addArr = array_diff($newAppointArr, $oldAppointArr);   // 需要新增的栏目id
                    $delArr = array_diff($oldAppointArr, $newAppointArr);   // 需要删除的栏目id

                    // 3. 新增：为新增栏目下所有内容添加自定义字段
                    if (!empty($addArr)) {
                        //列表页扩展字段
                        $content = Db::name('content')->where([['model', '=', $extfield['model']],['scode', 'in', $addArr]])->select()->toArray();
                        foreach ($content as $v) {
                            Db::name('content_ext')->insert(['content'=>$v['id'],'model'=>$extfield['model'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                            
                        }
                        //单页扩展字段
                        $single = Db::name('single')->where([['model', '=', $extfield['model']],['scode', 'in', $addArr]])->select()->toArray();
                        foreach ($single as $v) {
                            Db::name('single_ext')->insert(['single'=>$v['id'],'model'=>$extfield['model'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                            
                        }
                    }
                    // 4. 删除：为减少栏目下所有内容删除自定义字段
                    if (!empty($delArr)) {
                        //列表页扩展字段
                        $content = Db::name('content')->where([['model','=',$extfield['model']],['scode','in',$delArr]])->select()->toArray();
                        foreach ($content as $v) {
                            Db::name('content_ext')->where(['content'=>$v['id'],'model'=>$extfield['model'],'field'=>$data['field']])->delete();
                        }
                        //单页扩展字段
                        $single = Db::name('single')->where([['model','=',$extfield['model']],['scode','in',$delArr]])->select()->toArray();
                        foreach ($single as $v) {
                            Db::name('single_ext')->where(['single'=>$v['id'],'model'=>$extfield['model'],'field'=>$data['field']])->delete();
                        }
                    }
                    return json(['status'=>'success','msg'=>'更新成功']);
                }else{
                    Db::name('content_ext')->where(['field'=>$data['field']])->update(['description'=>$data['description'],'type'=>$data['type'],'sort'=>$data['sort']]);
                    Db::name('single_ext')->where(['field'=>$data['field']])->update(['description'=>$data['description'],'type'=>$data['type'],'sort'=>$data['sort']]);
                    return json(['status'=>'success','msg'=>'更新成功']);
                }
              
            }else{
                return json(['status'=>'fail','msg'=>'更新失败']);
            }
        
        }
    }


    public function click()
    {
        $data=input('post.');
        $extfield=Db::name('extfield')->where(['id'=>$data['id']])->find();
        $click=Db::name('extfield')->where(['id'=>$extfield['id']])->update([$data['field']=>$data['value']]);
        $name = $extfield['field'];
        $model=Db::name('model')->where(['id'=>$extfield['model']])->find();
        $this->logAction('修改扩展字段，ID:' . $extfield['id'] . '，字段名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value'] . '，模型名称:' . $model['name']);
        if($model['type']==1){
            Db::name('single_ext')->where(['field'=>$extfield['field']])->update(['sort'=>$data['value']]);
        }elseif ($model['type']==2){
            Db::name('content_ext')->where(['field'=>$extfield['field']])->update(['sort'=>$data['value']]);
        }
    }


    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        $extfield=Db::name('extfield')->find($id);
        $name = $extfield['field'];
        Db::name('content_ext')->where(['field'=>$extfield['field']])->delete();
        Db::name('single_ext')->where(['field'=>$extfield['field']])->delete();
        $res = Db::name('extfield')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除扩展字段，ID:' . $id . '，字段名称:' . $name . '，模型名称:' . $model['name']);
            return json(['status'=>'success','msg'=>'删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        $data=input('post.');
        $ids=$data['id'];
        $names = [];
        $models = [];
        if (is_array($ids)) {
            $fields = Db::name('extfield')->where('id', 'in', $ids)->column('field', 'id');
            $modelIds = Db::name('extfield')->where('id', 'in', $ids)->column('model', 'id');
            $modelNames = [];
            if (!empty($modelIds)) {
                $modelList = Db::name('model')->where('id', 'in', array_unique(array_values($modelIds)))->column('name', 'id');
            } else {
                $modelList = [];
            }
            foreach ($ids as $id) {
                $names[] = isset($fields[$id]) ? $fields[$id] : '';
                $models[] = isset($modelList[$modelIds[$id]]) ? $modelList[$modelIds[$id]] : '';
            }
        } else {
            $extfield = Db::name('extfield')->where('id', $ids)->find();
            $names[] = isset($extfield['field']) ? $extfield['field'] : '';
            $model = Db::name('model')->where('id', $extfield['model'])->find();
            $models[] = isset($model['name']) ? $model['name'] : '';
        }
        foreach($ids as $k=>$v){
            $extfield=Db::name('extfield')->where('id',$v)->find();
            $content_ext=Db::name('content_ext')->where(['field'=>$extfield['field']])->find();
            if($content_ext){
                Db::name('content_ext')->where(['field'=>$extfield['field']])->delete();
            }
            $single_ext=Db::name('single_ext')->where(['field'=>$extfield['field']])->find();
            if($single_ext){
                Db::name('single_ext')->where(['field'=>$extfield['field']])->delete();
            }
        }
        $del= Db::name('extfield')->where(['id'=>$data['id']])->delete();
        if($del){
            $modelInfo = '';
            if (count(array_unique($models)) === 1) {
                $modelInfo = '，模型名称:' . $models[0];
            } else {
                $modelInfo = '，模型名称:' . json_encode($models, JSON_UNESCAPED_UNICODE);
            }
            $this->logAction('批量删除扩展字段，ID:' . json_encode($ids) . '，字段名称:' . json_encode($names, JSON_UNESCAPED_UNICODE) . $modelInfo);
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
