<?php
declare (strict_types = 1);

namespace app\admin\controller;
use think\Request;
use think\facade\View;
use think\facade\Db;

class Content extends Common
{
   
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index($id)
    {

        
        if (!$this->hasPermission('content_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        // 获取模型信息
        $model = Db::name('model')->find($id);
        $config = Db::name('config')->where('id',1)->find();
        

        
        

        // 将分级数据转换为树形结构
        function buildTreeFromList($data, $pid = 0) {
            $tree = [];
            foreach ($data as $item) {
                if ($item['pid'] == $pid) {
                    $children = buildTreeFromList($data, $item['id']);
                    $node = [
                        'id' => $item['id'],
                        'title' => $item['name'], // 使用 name 作为分类名称
                        'spread' => ($pid == 0) // 如果是一级分类，更新为展开
                    ];
                    if (!empty($children)) {
                        $node['children'] = $children;
                    }
                    $tree[] = $node;
                }
            }
            return $tree;
        }
        
        //复杂性模式的情况处理
        if($config['structure']=='2'){
            // 获取分类信息
            $lst = Db::name('category')->order('sort asc,id asc')->select();
             // 树形结构
            $lst = buildTreeFromList($lst);
            // 分配数据到视图
            View::assign([
                'model' => $model,
                'config'=>$config,
                'lst' => json_encode($lst, JSON_UNESCAPED_UNICODE), // 转换为 JSON 格式
            ]);
        }

        //简单性模式的情况处理
        if($config['structure']=='1'){
            // 获取分类信息
            $lst = Db::name('category')->where(['model' => $id])->order('sort asc,id asc')->select();
            $lst = tree($lst);
             // 分配数据到视图
            View::assign([
                'model' => $model,
                'config'=>$config,
                'lst' => $lst,
            ]);
        }

       
       
       
        

        // 返回视图
        return View::fetch('index');
    }

    public function content()
    {
      
        $model = input('model');
        $scode = input('scode');
      
        $cate=Db::name('category')->where('id', $scode)->find();
        if($cate==''){
            $models=Db::name('model')->where(['id'=>$model])->find();
            $single='';
            $single_ext='';
        }else{
            $models=Db::name('model')->where(['id'=>$cate['model']])->find();
            if($models['type']=='1'){
                //单页情况下的
              
                $single=Db::name('single')->where('scode', $scode)->find();
                $single_ext=Db::name('single_ext')->where(['single'=>$single['id']])->where(['model'=>$single['model']])->order('sort asc, id asc')->select();
            }else{
                $single='';
                $single_ext='';
            }
        }
        $lst = Db::name('category')->order('id asc')->select();
        $lst = tree($lst);
       
        if($scode==''){
            $scode=0;
        }


        
        View::assign([
            'model' => $model,
            'models'=>$models,
            'scode' => $scode,
            'cate' => $cate,
            'lst' => $lst,
            'single'=>$single,
            'single_ext'=>$single_ext,
        ]);
        return View::fetch('content');
    }

    public function get_content(Request $request)
    {

        
         // 获取分页限制
        $limit = $request->param('limit') ? $request->param('limit') : 15;
        $model = $request->get('model', 0);
        $scode = $request->get('scode', 0);

        $builder = Db::name('content');

        

        // 处理搜索参数
        if ($request->param('searchParams')) {
            $searchParams = json_decode($request->param('searchParams'));

            // 按标题搜索
            if (!empty($searchParams->title)) {
                $title = trim($searchParams->title); // 去除前后空格
                if (!empty($title)) { // 确保去除空格后不为空
                    $builder->where('title', 'like', '%' . $title . '%');
                }
            }
        
            // 处理分类搜索（包括子分类）
            if (!empty($searchParams->scode)) {
                // 获取分类信息
                $cate = Db::name('category')->where(['id' => $searchParams->scode])->find();

                if ($cate) {
                    // 获取所有子分类ID
                    $categoryIds = $this->getAllChildCategoryIds($cate['id']);
                    // 添加当前分类ID
                    $categoryIds[] = $cate['id'];
                    
                    // 使用分类ID数组搜索
                    if (!empty($categoryIds)) {
                        $builder->where('scode', 'in', $categoryIds);
                    }
                }
            }

            // 日期搜索（单天）
            if (!empty($searchParams->daterange)) {
                $date = trim($searchParams->daterange);
                if (!empty($date)) {
                    $startTime = $date . ' 00:00:00';
                    $endTime = $date . ' 23:59:59';
                    $builder->where('date', '>=', $startTime)
                            ->where('date', '<=', $endTime);
                }
            }
        

        } else {
            // 无搜索参数时，按模型搜索和分类
            $where = [];

            // if ($model) {
            //     $builder->where('model', $model);
                
            // }
            // 分类及其子分类
            if ($scode) {
                // 获取所有子分类id
                $categoryIds = $this->getAllChildCategoryIds($scode);
                $categoryIds[] = $scode;
                if (!empty($categoryIds)) {
                    $builder->where('scode', 'in', $categoryIds);
                }
            }

            
            $builder->where($where);

        }

       
        $table = $builder->field('a.*, m.details')->order('a.id desc')->alias('a')->join('model m','a.model = m.id')->paginate(['list_rows' => $limit])->toArray();
       

        // 返回结果
        return json(['code' => 0, 'count' => $table['total'], 'data' => $table['data']]);

    }
    
   
    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function create()
    {
        
        if (!$this->hasPermission('content_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        // 获取模型参数
        $model = input('model');
        $scode = input('scode');
        $config = Db::name('config')->where('id',1)->find();

        
        //复杂性模式的情况处理
        if($config['structure']=='2'){

            //凭栏目ID获取模型ID
            $cate=Db::name('category')->where('id',$scode)->find();
            $model=Db::name('model')->where(['id'=>$cate['model']])->find();
            $model=$model['id'];
        }
       
        // 获取分类信息
        $lst = Db::name('category')->where('model', $model)->order('id asc')->select();
        $lst = tree($lst);
        
        if (empty($lst)) {
            $lst = Db::name('category')->where('model', $model)->order('id asc')->select();
        }
    
        // 获取扩展字段信息
        $extfield = Db::name('extfield')->where('model', $model)->order('sort asc, id asc')->select();
      
        
        
        //复杂性模式的情况处理
        if($config['structure']=='2'){
            // $extfield 是所有扩展字段数组，$scode 是当前分类id
            $showExtfield = [];
            foreach ($extfield as $field) {
                $appointArr = array_filter(explode(',', $field['appoint']));

                if (in_array($scode, $appointArr)) {
                    $showExtfield[] = $field;
                }
            }
            $extfield=$showExtfield;
        }

        // 分配数据到视图
        View::assign([
            'lst' => $lst,
            'model' => $model,
            'scode'=> $scode,
            'extfield' => $extfield,
        ]);

        // 返回视图
        return View::fetch('add');
    }

    public function getcontent(Request $request)
    {
        // 获取分页限制
        $limit = $request->param('limit') ? $request->param('limit') : 15;

        // 初始化查询构建器
        $builder = Db::name('content')->order('sort asc, id desc');

        // 处理搜索参数
        if ($request->param('searchParams')) {
            $searchParams = json_decode($request->param('searchParams'));

            // 按标题搜索
            if (!empty($searchParams->title)) {
                $title = trim($searchParams->title); // 去除前后空格
                if (!empty($title)) { // 确保去除空格后不为空
                    $builder->where('title', 'like', '%' . $title . '%');
                }
            }
            
            // 按模型搜索
            if (!empty($searchParams->model)) {
                $builder->where('model', $searchParams->model);
            }

            // 处理分类搜索（包括子分类）
            if (!empty($searchParams->scode)) {
                // 获取分类信息
                $cate = Db::name('category')->where(['id' => $searchParams->scode])->find();

                if ($cate) {
                    // 获取所有子分类ID
                    $categoryIds = $this->getAllChildCategoryIds($cate['id']);
                    // 添加当前分类ID
                    $categoryIds[] = $cate['id'];
                    
                    // 使用分类ID数组搜索
                    if (!empty($categoryIds)) {
                        $builder->where('scode', 'in', $categoryIds);
                    }
                }
            }

            // 日期搜索（单天）
            if (!empty($searchParams->daterange)) {
                $date = trim($searchParams->daterange);
                if (!empty($date)) {
                    $startTime = $date . ' 00:00:00';
                    $endTime = $date . ' 23:59:59';
                    $builder->where('date', '>=', $startTime)
                            ->where('date', '<=', $endTime);
                }
            }
        } else {
            // 无搜索参数时，按模型搜索
            $builder->where(['model' => $request->param('model')]);
        }

        // 获取分页数据
        $table = $builder->paginate(['list_rows' => $limit])
                        ->toArray();

        // 返回结果
        return json(['code' => 0, 'count' => $table['total'], 'data' => $table['data']]);
    }

    /**
     * 递归获取所有子分类ID
     *
     * @param int $categoryId 当前分类ID
     * @return array 所有子分类ID数组
     */
    private function getAllChildCategoryIds($categoryId)
    {
        $childIds = [];
        
        // 获取直接子分类
        $children = Db::name('category')->where('pid', $categoryId)->select()->toArray();
        
        foreach ($children as $child) {
            // 添加子分类ID
            $childIds[] = $child['id'];
            // 递归获取子分类的子分类
            $grandChildIds = $this->getAllChildCategoryIds($child['id']);
            if (!empty($grandChildIds)) {
                $childIds = array_merge($childIds, $grandChildIds);
            }
        }
        
        return $childIds;
    }
    

    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        if (!$this->hasPermission('content_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        // 接收提交的数据
        $data = input('post.');

        // 获取分类信息
        $cate = Db::name('category')->where(['id' => $data['scode']])->find();
        $data['name'] = $cate['name'];
        $data['model'] = $cate['model'];

        if (empty($data['description']) && isset($data['content']) && is_string($data['content'])) {
            // 1. 移除HTML标签
            $text = strip_tags($data['content']);
            // 2. 替换特殊空白字符为普通空格
            $text = str_replace(['&nbsp;', '　'], ' ', $text);
            // 3. 将多个连续空格替换为单个空格
            $text = preg_replace('/\s+/', ' ', $text);
            // 4. 去除首尾空白
            $text = trim($text);
            // 5. 截取适当长度
            $data['description'] = mb_substr($text, 0, 300, 'utf-8');
        }

        //判断URL名称是否存在
        if($data['filename']!==''){
            // 检查 URL 名称是否合法（不允许包含斜杠）
            if (!preg_match('/^[a-zA-Z0-9\-_]+$/', $data['filename'])) {
                return json(['msg' => 'URL名称只允许字母、数字、横线、下划线组成，不允许包含斜杠', 'status' => 'fail']);
            }
            $filename = Db::name('content')->where(['filename' => $data['filename']])->find();
            if ($filename) {
                return json(['msg' => 'URL名称已存在，请重新更新', 'status' => 'fail']);
            }
        }

        // 如果有外链，检查是否包含协议前缀
        if (!empty($data['outlink'])) {
            // 检查是否包含协议前缀 http:// 或 https://
            if (!preg_match('/^https?:\/\//i', $data['outlink'])) {
                // 如果不包含协议前缀，添加 http://
                $data['outlink'] = 'http://' . $data['outlink'];
            }
        }

        

        // 无缩略图时，自动提取内容第一张图为缩略图, 没有内容图的话，更新缩略图为指定空图片
        if (empty($data['ico'])) {
            preg_match_all('/<img.+?src="(?P<src>[^"]+)"/i', $data['content'], $matches);
            $images = $matches['src'];
            $config = Db::name('config')->where('id', 1)->find();
            $data['ico'] = $images[0] ?? $config['default_ico'];
        }

        // 处理自定义字段
        $prefix = 'ext_';
        $extFields = array_filter($data, function($key) use ($prefix) {
            return strpos($key, $prefix) === 0;
        }, ARRAY_FILTER_USE_KEY);

        // 插入内容数据
        $contentId = Db::name('content')->strict(false)->insertGetId($data);

        
        // 如果更新了url名称，那就链接后缀以filename为准
        $contentlink = $contentId;
        if($data['filename'] !== '') {
            $contentlink = $data['filename'];
        }


         // 使用分类的link作为基础，去掉末尾的斜杠
        $baseLink = rtrim($cate['link'], '/');
        // 生成内容链接
        $link = $baseLink . '/' . $contentlink . '.html';
        
        // 确保链接格式正确，替换多余斜杠
        $link = preg_replace('#/+#', '/', $link);
        
        Db::name('content')->where(['id' => $contentId])->update(['link' => $link]);

        // 插入扩展字段数据
        foreach ($extFields as $key => $value) {
            $extField = Db::name('extfield')->where('field', $key)->find();
            Db::name('content_ext')->insert([
                'content' => $contentId,
                'field' => $key,
                'value' => $value,
                'type' => $extField['type'],
                'model' => $extField['model'],
                'description' => $extField['description']
            ]);
        }

        if ($contentId) {
            $title = isset($data['title']) ? $data['title'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '显示' : '隐藏') : '';
            $this->logAction('添加内容列表，ID:' . $contentId . '，标题:' . $title . '，状态:' . $statusText);
            $this->markSitemapDirty();
        }
        return $contentId ? json(['msg' => '添加成功', 'status' => 'success']) : json(['msg' => '添加失败', 'status' => 'fail']);
    }

    public function edit($id)
    {
        if (!$this->hasPermission('content_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑权限！</div>';
        }
        // 获取内容信息
        $edit = Db::name('content')->find($id);
        $pics = explode(',', $edit['pics']); // 字符串转换为数组

        // 获取扩展字段信息 //和添加扩展字段排序一致
        $content_ext = Db::name('content_ext')->alias('ce')->join('extfield ef', 'ce.field = ef.field AND ef.model = ce.model')->where([
            'ce.content' => $edit['id'], 
            'ce.model' => $edit['model']])->order('ef.sort asc, ef.id asc')->select();

       

        // 获取分类信息
        $lst = Db::name('category')->where(['model' => $edit['model']])->order('id asc')->select();
        $lst = tree($lst);
        if (empty($lst)) {
            $lst = Db::name('category')->where(['model' => $edit['model']])->order('id asc')->select();
        }
        

        // 分配数据到视图
        View::assign([
            'edit' => $edit,
            'pics' => $pics,
            'lst' => $lst,
            'content_ext' => $content_ext,
        ]);

        return View::fetch('edit');
    }


    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        // 接收提交的数据
        $data = input('post.');
        $id=$data['id'];
        // 获取分类信息
        $cate = Db::name('category')->where(['id' => $data['scode']])->find();
        $data['name'] = $cate['name'];
        $data['model'] = $cate['model'];

        if (empty($data['description']) && isset($data['content']) && is_string($data['content'])) {
            // 1. 移除HTML标签
            $text = strip_tags($data['content']);
            // 2. 替换特殊空白字符为普通空格
            $text = str_replace(['&nbsp;', '　'], ' ', $text);
            // 3. 将多个连续空格替换为单个空格
            $text = preg_replace('/\s+/', ' ', $text);
            // 4. 去除首尾空白
            $text = trim($text);
            // 5. 截取适当长度
            $data['description'] = mb_substr($text, 0, 300, 'utf-8');
        }

       
        // 获取数据库中的原始数据
        $originalData = Db::name('content')->where('id', $id)->find();

        // 获取 content_ext 表中的扩展字段数据
        $extFields = Db::name('content_ext')->where('content', $id)->select()->toArray();

        // 将扩展字段数据合并到原始数据中
        foreach ($extFields as $extField) {
            $originalData[$extField['field']] = $extField['value'];
        }
       
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            $old = isset($originalData[$key]) ? $originalData[$key] : '';
            $old = is_null($old) ? '' : $old;
            $new = is_null($value) ? '' : $value;
            if ($old != $new) {
                $hasChanges = true;
                break;
            }
        }

        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何更新']);
        }


        // 如果有外链，检查是否包含协议前缀
        if (!empty($data['outlink'])) {
            // 检查是否包含协议前缀 http:// 或 https://
            if (!preg_match('/^https?:\/\//i', $data['outlink'])) {
                // 如果不包含协议前缀，添加 http://
                $data['outlink'] = 'http://' . $data['outlink'];
            }
        }


        // 无缩略图时，自动提取内容第一张图为缩略图, 没有内容图的话，更新缩略图为指定空图片
        if (empty($data['ico'])) {
            preg_match_all('/<img.+?src="(?P<src>[^"]+)"/i', $data['content'], $matches);
            $images = $matches['src'];
            $config = Db::name('config')->where('id', 1)->find();
            $data['ico'] = $images[0] ?? $config['default_ico'];
        }

        // 如果更新了url名称，那就链接后缀以filename为准
        $contentlink=$id;
        if($data['filename']!==''){
            // 检查 URL 名称是否合法（不允许包含斜杠）
            if (!preg_match('/^[a-zA-Z0-9\-_]+$/', $data['filename'])) {
                return json(['msg' => 'URL名称只允许字母、数字、横线、下划线组成，不允许包含斜杠', 'status' => 'fail']);
            }

            $contentlink=$data['filename'];
            //判断URL名称是否存在
            $filename = Db::name('content')->where('id','<>',$id)->where(['filename' => $data['filename']])->find();
            if ($filename) {
                return json(['msg' => 'URL名称已存在，请重新更新', 'status' => 'fail']);
            }
        }

       
        if ($data['filename'] == '') {
            $link = $cate['link'] . $id. '.html';
        } else {
            $link = $cate['link'] . $data['filename']. '.html';
        }

        
        $data['link'] = $link;

        // 更新内容数据
        Db::name('content')->strict(false)->where(['id' => $id])->update($data);

        // 处理自定义字段
        $prefix = 'ext_';
        $extFields = array_filter($data, function($key) use ($prefix) {
            return strpos($key, $prefix) === 0;
        }, ARRAY_FILTER_USE_KEY);

        // 更新扩展字段数据
        foreach ($extFields as $key => $value) {
            $extField = Db::name('extfield')->where('field', $key)->find();
            Db::name('content_ext')->where(['content' => $id, 'field' => $extField['field']])->update(['value' => $value]);
        }

        if ($id) {
            $title = isset($data['title']) ? $data['title'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '显示' : '隐藏') : '';
            $this->logAction('编辑内容列表，ID:' . $id . '，标题:' . $title . '，状态:' . $statusText);
            $this->markSitemapDirty();
        }
        return json(['status' => 'success', 'msg' => '更新成功']);
    }


    
    public function click()
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        // 接收提交的数据
        $data = input('post.');

    // 更新点击量
    Db::name('content')->where('id', $data['id'])->update([$data['field'] => $data['value']]);
    $content = Db::name('content')->where('id', $data['id'])->find();
    $title = isset($content['title']) ? $content['title'] : '';
    $this->logAction('更新内容字段，ID:' . $data['id'] . '，标题:' . $title . '，字段:' . $data['field'] . '，值:' . $data['value']);

    }

    public function istop(Request $request)
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $istop = $request->param('istop');
        $res = Db::name('content')->where('id', $id)->update(['istop' => $istop]);
        if($res !== false){
            $this->markSitemapDirty();
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}

   

    public function isrecommend(Request $request)
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $isrecommend = $request->param('isrecommend');
        $res = Db::name('content')->where('id', $id)->update(['isrecommend' => $isrecommend]);
        if($res !== false){
            $content = Db::name('content')->where('id', $id)->find();
            $title = isset($content['title']) ? $content['title'] : '';
            $recommendText = $isrecommend == 1 ? '推荐' : '不推荐';
            $this->logAction('更新内容推荐，ID:' . $id . '，标题:' . $title . '，状态:' . $recommendText);
            $this->markSitemapDirty();
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}

  

    public function isheadline(Request $request)
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $isheadline = $request->param('isheadline');
        $res = Db::name('content')->where('id', $id)->update(['isheadline' => $isheadline]);
        if($res !== false){
            $this->markSitemapDirty();
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}


    public function status(Request $request)
    {
        if (!$this->hasPermission('content_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $res = Db::name('content')->where('id', $id)->update(['status' => $status]);
        if($res !== false){
            $content = Db::name('content')->where('id', $id)->find();
            $title = isset($content['title']) ? $content['title'] : '';
            $statusText = $status == 1 ? '显示' : '隐藏';
            $this->logAction('更新内容状态，ID:' . $id . '，标题:' . $title . '，状态:' . $statusText);
            $this->markSitemapDirty();
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}


    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        if (!$this->hasPermission('content_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        // 删除内容数据
        $content = Db::name('content')->where('id', $id)->find();
        $title = isset($content['title']) ? $content['title'] : '';
        $res = Db::name('content')->where('id', $id)->delete();

        // 如果删除成功，删除扩展字段数据
        if ($res) {
            Db::name('content_ext')->where('content', $id)->delete();
            $this->logAction('删除内容列表，ID:' . $id . '，标题:' . $title);
            $this->markSitemapDirty();
            return json(['status' => 'success', 'msg' => '删除成功']);
        }
        return json(['status' => 'fail', 'msg' => '删除失败']);
    }


    public function del()
    {
        // 接收提交的数据
        $data=input('post.');

        if (!$this->hasPermission('content_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $ids = $data['id'];
        $titles = [];
        if (is_array($ids)) {
            $contents = Db::name('content')->where('id', 'in', $ids)->column('title', 'id');
            foreach ($ids as $id) {
                $titles[] = isset($contents[$id]) ? $contents[$id] : '';
            }
        } else {
            $content = Db::name('content')->where('id', $ids)->find();
            $titles[] = isset($content['title']) ? $content['title'] : '';
        }
        $del= Db::name('content')->where(['id'=>$ids])->delete();

        if($del){
            $this->logAction('批量删除内容列表，ID:' . json_encode($ids) . '，标题:' . json_encode($titles));
            $this->markSitemapDirty();
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }
        return json(['status'=>'fail','msg'=>'批量删除失败']);
    }

    private function markSitemapDirty()
    {
        try {
            (new \app\home\controller\Sitemap())->markChanged();
        } catch (\Throwable $e) {
            // 静默
        }
    }
}
