<?php
namespace app\admin\controller;

use app\BaseController;
use think\facade\Db;
use think\facade\View;

class Common extends BaseController
{

    public function logAction($event)
    {
        $adname = session('adname');
        $username = is_array($adname) ? ($adname['adname'] ?? '') : $adname;
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $os = $this->getOS($userAgent);
        $browser = $this->getBrowser($userAgent);
        $time = date('Y-m-d H:i:s');
        
        $data = [
            'username' => $username,
            'time' => $time,
            'event' => $event,
            'os' => $os,
            'browser' => $browser,
            'ip' => $ip
        ];
        try {
            Db::name('log')->strict(false)->insert($data);
        } catch (\Throwable $e) {
            // 可选：写入文件或忽略
        }
    }

    
    
    // 当前用户权限缓存
    protected $userPermissions = [];
    public function initialize()
    {

        if(!file_exists(__DIR__ . '/../../../install/install.lock')==true){
            header('Location: /installs');
            exit;
        }

        // 获取访问来源
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
        $refererType = '直接访问';

        if (empty($referer)) {
            $refererType = '直接访问';
        } elseif (strpos($referer, 'baidu.com') !== false) {
            $refererType = '百度搜索';
        } elseif (strpos($referer, 'so.com') !== false) {
            $refererType = '360搜索';
        } elseif (strpos($referer, 'sogou.com') !== false) {
            $refererType = '搜狗搜索';
        } elseif (strpos($referer, 'google.') !== false) {
            $refererType = '谷歌搜索';
        } elseif (strpos($referer, 'bing.com') !== false) {
            $refererType = '必应搜索';
        } elseif (strpos($referer, 'sm.cn') !== false) {
            $refererType = '神马搜索';
        } elseif (strpos($referer, 'weixin.qq.com') !== false || strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'micromessenger') !== false) {
            $refererType = '微信访问';
        } elseif (strpos($referer, $_SERVER['HTTP_HOST']) !== false) {
            $refererType = '站内跳转';
        } else {
            $refererType = '外部网站';
        }
        
        // 获取用户浏览器
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
        $browser = $this->getBrowser($userAgent);
        

        // 获取操作系统信息
        $os = $this->getOS($userAgent);

        // 判断当前是电脑还是手机访问
        $deviceType = $this->getDeviceType($userAgent);


        // 记录当天访问ip
        $ip = $_SERVER['REMOTE_ADDR'];

        // 查询当天数据
        $startOfDay = date("Y-m-d 00:00:00");
        $endOfDay = date("Y-m-d 23:59:59");
        $date = Db::name('count')->where('ip', $ip)->whereBetweenTime('time', $startOfDay, $endOfDay)->find();

        $ipInfo = ['addr' => ''];
        if ($date) {
            // 如果当天已记录，直接用已有的ip_addr
            $ipInfo['addr'] = $date['ip_addr'];
        } else {
            // 获取IP地址信息
            if ($ip === '127.0.0.1' || $ip === '::1') {
                $ipInfo['addr'] = '本地';
            } else {
                $url = "http://whois.pconline.com.cn/ipJson.jsp?ip={$ip}&json=true";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
                $ipJson = curl_exec($ch);
                curl_close($ch);

                // 转码为UTF-8
                $ipJson = mb_convert_encoding($ipJson, 'UTF-8', 'GBK');
                $ipData = json_decode($ipJson, true);
                if ($ipData && isset($ipData['pro']) && isset($ipData['city'])) {
                    if (empty($ipData['pro']) && empty($ipData['city']) && !empty($ipData['addr'])) {
                        $ipInfo['addr'] = $ipData['addr'];
                    } else {
                        $ipInfo['addr'] = $ipData['pro'] . $ipData['city'];
                    }
                } else {
                    $ipInfo['addr'] = '';
                }
                if (empty($ipInfo['addr'])) {
                    $ipInfo['addr'] = '未知';
                }
            }
        }

        // 后续写入数据库时
        $data = [
            'time' => date("Y-m-d H:i:s"),
            'ip' => $ip,
            'ip_addr'=> $ipInfo['addr'],
            'browser' => $browser,
            'os' => $os,
            'device_type' => $deviceType,
            'referer_type' => $refererType
        ];

        if (!$date) {
            Db::name('count')->insert($data);
        }

      
        if (isset($_SERVER['REQUEST_URI'])) {
            $uri = strtolower($_SERVER['REQUEST_URI']);
            $adname = session('adname');
            $config = Db::name('config')->where('id', 1)->find();
            $admin_entry = '/' . strtolower($config['admin_path']) . '.php';

            // 未登录时，禁止访问所有 /admin/ 路径（只允许访问后台入口文件）
            if ($adname == null) {
                if (strpos($uri, '/admin/') === 0) {
                    echo '<script>window.location.href="' . $admin_entry . '?s=login"</script>';
                    exit;
                }
                // 不是入口文件也跳转到登录
                if ($uri !== $admin_entry && strpos($uri, $admin_entry . '?s=login') !== 0) {
                    echo '<script>window.location.href="' . $admin_entry . '?s=login"</script>';
                    exit;
                }
            } else {
                // 已登录时，访问 /admin/ 路径，强制跳转到后台入口
                if ($uri === '/admin/') {
                    echo '<script>window.location.href="' . $admin_entry . '"</script>';
                    exit;
                }
            }
        }
       
        $adname = session('adname');
        $config = Db::name('config')->where('id', 1)->find();
        if($adname==null){
            echo '<script>window.location.href="/' . $config['admin_path'] . '.php?s=login"</script>';
        };

        $model=Db::name('model')->where('status',1)->order('sort asc,id asc')->select();
        $system=Db::name('system')->where('id',1)->find();

        // 加载当前用户权限
        $adminId = session('admin_id');
        if (!$adminId && is_array($adname) && isset($adname['id'])) {
            $adminId = $adname['id'];
            session('admin_id', $adminId);
        }
        if ($adminId && $adminId == 1) {
            $permissions = ['*'];
        } else {
            $user = $adminId ? Db::name('admin')->where('id', $adminId)->find() : null;
            $role = ($user && isset($user['role_id'])) ? Db::name('auth_role')->where('id', $user['role_id'])->find() : null;
            $permissions = [];
            if ($role && !empty($role['permissions'])) {
                $permissions = array_filter(array_map('trim', explode(',', $role['permissions'])));
            }
        }
        $this->userPermissions = $permissions;

      
       
        View::assign([
            'system'=>$system,
            'adname'=>$adname,
            'model'=>$model,
            'userPermissions' => $permissions,
        ]);

        // 后台也触发一次延迟 sitemap 生成检查（例如后台一直有人操作而前台无访问时确保可触发）
        try { (new \app\home\controller\Sitemap())->lazyGenerate(); } catch (\Throwable $e) {}

    }

    /**
     * 检查当前登录用户是否包含指定权限
     * @param string $perm 权限标识
     * @return bool
     */
    protected function hasPermission($perm)
    {
        // 超级管理员跳过检查（假设 admin_id == 1）
        $adminId = session('admin_id');
        if ($adminId && $adminId == 1) {
            return true;
        }
        if (empty($perm)) return false;
        return in_array($perm, $this->userPermissions);
    }

    // 获取浏览器信息
    public function getBrowser($userAgent)
    {
        if (strpos($userAgent, 'MSIE') !== false || strpos($userAgent, 'Trident') !== false) {
            return 'Internet Explorer';
        } elseif (strpos($userAgent, 'Firefox') !== false) {
            return 'Firefox';
        } elseif (strpos($userAgent, 'Chrome') !== false) {
            return 'Chrome';
        } elseif (strpos($userAgent, 'Safari') !== false) {
            return 'Safari';
        } elseif (strpos($userAgent, 'Opera') !== false || strpos($userAgent, 'OPR') !== false) {
            return 'Opera';
        } else {
            return 'Other';
        }
    }

    // 获取操作系统信息
    public  function getOS($userAgent)
    {
        if (preg_match('/Windows NT 10.0/i', $userAgent)) {
            return 'Windows 10';
        } elseif (preg_match('/Windows NT 6.3/i', $userAgent)) {
            return 'Windows 8.1';
        } elseif (preg_match('/Windows NT 6.2/i', $userAgent)) {
            return 'Windows 8';
        } elseif (preg_match('/Windows NT 6.1/i', $userAgent)) {
            return 'Windows 7';
        } elseif (preg_match('/Windows NT 6.0/i', $userAgent)) {
            return 'Windows Vista';
        } elseif (preg_match('/Windows NT 5.1/i', $userAgent)) {
            return 'Windows XP';
        } elseif (preg_match('/Mac OS X/i', $userAgent)) {
            return 'Mac OS X';
        } elseif (preg_match('/Linux/i', $userAgent)) {
            return 'Linux';
        } elseif (preg_match('/iPhone/i', $userAgent)) {
            return 'iPhone';
        } elseif (preg_match('/iPad/i', $userAgent)) {
            return 'iPad';
        } elseif (preg_match('/Android/i', $userAgent)) {
            return 'Android';
        } else {
            return 'Other';
        }
    }

    // 判断当前是电脑还是手机访问
    private function getDeviceType($userAgent)
    {
        $userAgent = strtolower($userAgent);
        if (preg_match('/ipad/i', $userAgent)) {
            return '平板';
        } elseif (preg_match('/tablet|nexus 7|nexus 10|xoom|sm-t|gt-p|kindle|silk/i', $userAgent)) {
            return '平板';
        } elseif (preg_match('/mobile|android|iphone|ipod|blackberry|iemobile|opera mini/i', $userAgent)) {
            return '手机';
        } elseif (preg_match('/windows nt|macintosh|linux/i', $userAgent)) {
            return '电脑';
        } else {
            return '其他';
        }
    }
}