<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Banner extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        if (!$this->hasPermission('banner_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        } else {
            return View::fetch('index');
        }
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

   

    public function create()
    {
        if (!$this->hasPermission('banner_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
        }
        $gid=Db::name('banner')->distinct(true)->field('gid')->order('gid asc')->select();
        View::assign([
            'gid'=>$gid
        ]);
        return View::fetch('add');
    }

    public function getbanner(Request $request)
    {

        if (!$this->hasPermission('banner_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('banner')?$request->param('limit'):10;
        $table = Db::name('banner')->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        if (!$this->hasPermission('banner_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data=input('post.');
        $data['time']=time();
        if($data['gid']==''){
            $count=Db::name('banner')->count();
            if($count=='0'){
                $data['gid']='1';
            }else{
                $gid=Db::name('banner')->where('status',1)->order('gid desc')->limit(1)->find();
                $data['gid']=$gid['gid'] + '1';
            }
        }
        $banner=Db::name('banner')->strict(false)->insert($data);
        if($banner){
            $title = isset($data['title']) ? $data['title'] : '';
            $this->logAction('添加轮播图片，ID:' . $data['gid'] . '，标题:' . $title);
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        if (!$this->hasPermission('banner_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
        }
        $edit=Db::name('banner')->find($id);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        if (!$this->hasPermission('banner_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $id=$data['id'];
        // 获取数据库中的原始数据
        $originalData = Db::name('banner')->where('id', $id)->find();

        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }

        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }

        if($data['gid']==''){
            $count=Db::name('banner')->count();
            if($count=='0'){
                $data['gid']='1';
            }else{
                $gid=Db::name('banner')->where('status',1)->order('gid desc')->limit(1)->find();
                $data['gid']=$gid['gid'] + '1';
            }
        }

        $banner=Db::name('banner')->where(['id'=>$data['id']])->strict(false)->save($data);
        if($banner){
            $title = isset($data['title']) ? $data['title'] : '';
            $this->logAction('编辑轮播图片，ID:' . $data['id'] . '，标题:' . $title);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }

    public function click()
    {
        if (!$this->hasPermission('banner_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $banner = Db::name('banner')->where(['id'=>$data['id']])->find();
        Db::name('banner')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        $title = isset($banner['title']) ? $banner['title'] : '';
        $this->logAction('修改轮播图片，ID:' . $data['id'] . '，标题:' . $title . '，字段:' . $data['field'] . '，值:' . $data['value']);
    }

    public function status(Request $request)
    {
        if (!$this->hasPermission('banner_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $banner = Db::name('banner')->where('id', $id)->find();
        $res = Db::name('banner')->where('id', $id)->update(['status' => $status]);
        if($res !== false){
            $statusText = $status == 1 ? '显示' : '隐藏';
            $title = isset($banner['title']) ? $banner['title'] : '';
            $this->logAction('更新轮播图片，ID:' . $id . '，标题:' . $title . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
    }

    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        if (!$this->hasPermission('banner_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $banner = Db::name('banner')->where('id', $id)->find();
        $res = Db::name('banner')->where('id',$id)->delete();
        if($res){
            $title = isset($banner['title']) ? $banner['title'] : '';
            $this->logAction('删除轮播图片，ID:' . $id . '，标题:' . $title);
            return json(['status'=>'success','msg'=>'删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        if (!$this->hasPermission('banner_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $titles = [];
        if (is_array($ids)) {
            $banners = Db::name('banner')->where('id', 'in', $ids)->column('title', 'id');
            foreach ($ids as $id) {
                $titles[] = isset($banners[$id]) ? $banners[$id] : '';
            }
        } else {
            $banner = Db::name('banner')->where('id', $ids)->find();
            $titles[] = isset($banner['title']) ? $banner['title'] : '';
        }
        $del= Db::name('banner')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除轮播图片，ID:' . json_encode($ids) . '，标题:' . json_encode($titles));
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
