<?php
namespace app\admin\controller;

use think\facade\Db;
use think\facade\View;
use think\Request;

class Authuser extends Common
{
    public function index()
    {
        if (!$this->hasPermission('authuser_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        return View::fetch('index');
    }

    public function getauthuser(Request $request)
    {
        if (!$this->hasPermission('authuser_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('limit')?$request->param('limit'):10;
        $table = Db::name('admin')->alias('a')
            ->join('auth_role b','b.id=a.role_id')
            ->field('a.*, a.id as admin_id, b.name as role_name')
            ->order('a.id asc')
            ->paginate(['list_rows'=>$limit])
            ->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }

    public function create()
    {
        if (!$this->hasPermission('authuser_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        $roles = Db::name('auth_role')->where('status',1)->order('sort asc,id asc')->select()->toArray();
        View::assign([
            'roles'=>$roles,
        ]);
        return View::fetch('add');
    }

   
    public function edit($id)
    {
        if (!$this->hasPermission('authuser_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑权限！</div>';
        }
        $edit=Db::name('admin')->find($id);
        $roles = Db::name('auth_role')->where('status',1)->order('id asc')->select()->toArray();
        View::assign([
            'edit'=>$edit,
            'roles'=>$roles
        ]);
        return View::fetch('edit');
    }


    public function status(Request $request)
    {
        $id = $request->param('id');
        $status = $request->param('status');
        $admin = Db::name('admin')->where('id', $id)->find();
        Db::name('admin')->where('id', $id)->update(['status' => $status]);
        $adname = isset($admin['adname']) ? $admin['adname'] : '';
        $statusText = $status == 1 ? '启用' : '禁用';
        $this->logAction('设置用户状态，ID:' . $id . '，用户名:' . $adname . '，状态:' . $statusText);
        return json(['status' => 'success', 'msg' => '状态已更新']);
	}

    

    public function save(Request $request)
    {
        if (!$this->hasPermission('authuser_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data = input('post.');
        $data['adname'] = trim($data['adname']);
        if (Db::name('admin')->where('adname', $data['adname'])->find()) {
            return json(['status' => 'fail', 'msg' => '用户名已存在']);
        }
        $data['password'] = md5($data['password']);
        $id = Db::name('admin')->strict(false)->insertGetId($data);
        if ($id) {
            $adname = isset($data['adname']) ? $data['adname'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : '';
            $this->logAction('添加用户，ID:' . $id . '，用户名:' . $adname . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '添加成功']);
        } else {
            return json(['status' => 'fail', 'msg' => '添加失败']);
        }
    }

    public function update()
    {
        if (!$this->hasPermission('authuser_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $data['adname'] = trim($data['adname']);
        $id=$data['id'];
        if(isset($data['password']) && $data['password'] != ''){
            $data['password'] = md5($data['password']);
        }else{
            unset($data['password']);
        }
        $auth_user=Db::name('admin')->where('id',$id)->strict(false)->update($data);
        if($auth_user){
            $admin = Db::name('admin')->where('id', $id)->find();
            $adname = isset($admin['adname']) ? $admin['adname'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : (isset($admin['status']) ? ($admin['status'] == 1 ? '启用' : '禁用') : '');
            $this->logAction('编辑用户，ID:' . $id . '，用户名:' . $adname . '，状态:' . $statusText);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }

    public function delete($id)
    {
        if (!$this->hasPermission('authuser_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $admin = Db::name('admin')->where('id', $id)->find();
        $adname = isset($admin['adname']) ? $admin['adname'] : '';
        $res = Db::name('admin')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除用户，ID:' . $id . '，用户名:' . $adname);
            return json(['status'=>'success','msg'=>'删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }


    public function del()
    {
        if (!$this->hasPermission('authuser_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $adnames = [];
        if (is_array($ids)) {
            $admins = Db::name('admin')->where('id', 'in', $ids)->column('adname', 'id');
            foreach ($ids as $id) {
                $adnames[] = isset($admins[$id]) ? $admins[$id] : '';
            }
        } else {
            $admin = Db::name('admin')->where('id', $ids)->find();
            $adnames[] = isset($admin['adname']) ? $admin['adname'] : '';
        }
        $del= Db::name('admin')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除用户，ID:' . json_encode($ids, JSON_UNESCAPED_UNICODE) . '，用户名:' . json_encode($adnames, JSON_UNESCAPED_UNICODE));
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }


    
}
