
    var styleMap = {
        simple: {
            desc: '经典风格：简洁、正式、结构清晰，适合大多数场景。',
            prompt: '请用经典简约风格进行文案创作。'
        },
        symbol: {
            desc: '元素符号：符号丰富、视觉感强，适合新媒体、创意内容。',
            prompt: '请用元素符号丰富、视觉感强烈的风格进行文案创作，适当使用emoji或图标增强表现力。'
        },
        visualization: {
            desc: '数据比对：数据化思维、更易理解、适合用于商业分析、报告等场景。',
            prompt: '请用数据比对进行文案创作，使用数据表格、流程图、可视化图表等展示方式。'
        },
    };

    layui.use(['form', 'layer'], function () {
        var form = layui.form, layer = layui.layer;

            

        // 监听AI助手按钮点击
        $(document).on('click', '.ai', function () {

            // 每次点击都重新获取
            var lastPrompt = localStorage.getItem('ai_prompt') || '';
            var lastWordCount = localStorage.getItem('ai_wordcount') || '1500';
            var lastStyle = localStorage.getItem('ai_style') || 'simple';

            var lastTitle = localStorage.getItem('ai_seo_title');
            lastTitle = lastTitle === '1';

            var lastKeywords = localStorage.getItem('ai_seo_keywords');
            lastKeywords = lastKeywords === '1';

            var lastDesc = localStorage.getItem('ai_seo_desc');
            lastDesc = lastDesc === '1';

            var aiHtml = `
                <form class="layui-form" style="padding:10px;">
                    <div class="layui-form-item layui-form-text">
                        <label class="layui-form-label required">提示词</label>
                        <div class="layui-input-block">
                            <textarea id="ai-prompt" placeholder="帮我写一篇教育培训行业的文章" style="width:100%;height:120px;" class="layui-textarea">${lastPrompt}</textarea>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">创作字数</label>
                        <div class="layui-input-inline layui-input-wrap">
                            <input type="number" id="ai-wordcount" value="${lastWordCount}" autocomplete="off" class="layui-input">
                        </div>
                        <div class="layui-form-mid layui-text-em">字数</div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">创作风格</label>
                        <div class="layui-input-block">
                                <input type="radio" name="style" value="simple" title="经典风格" lay-filter="style" ${lastStyle === 'simple' ? 'checked' : ''}>
                            <input type="radio" name="style" value="symbol" title="元素符号" lay-filter="style" ${lastStyle === 'symbol' ? 'checked' : ''}>
                            <input type="radio" name="style" value="visualization" title="数据比对" lay-filter="style" ${lastStyle === 'visualization' ? 'checked' : ''}>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">风格说明</label>
                        <div class="layui-input-block">
                            <div id="style-desc" style="padding:8px 12px;background:#f8f9fa;border-radius:4px;border:1px solid #eee;color:#666;font-size:13px;"></div>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">是否生成</label>
                        <div class="layui-input-block">
                            <input type="checkbox" id="ai-seo-title" lay-filter="ai-seo-title" title="标题" ${lastTitle ? 'checked' : ''}>
                            <input type="checkbox" id="ai-seo-keywords" lay-filter="ai-seo-keywords" title="SEO关键词" ${lastKeywords ? 'checked' : ''}>
                            <input type="checkbox" id="ai-seo-desc" lay-filter="ai-seo-desc" title="SEO描述" ${lastDesc ? 'checked' : ''}>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <div class="layui-input-block">
                            <button type="button" id="ai-generate-btn" class="layui-btn">AI生成</button>
                        </div>
                    </div>
                </form>
                `;
            layer.open({
                type: 1,
                title: 'AI文案助手',
                offset: 'r',
                anim: 'slideLeft',
                area: ['500px', '100%'],
                shade: 0.1,
                shadeClose: true,
                content: aiHtml,
                success: function (layero, index) {
                    // 先渲染，保证checked属性生效
                    form.render('radio');
                    form.render('checkbox');

                    // 打印当前选中状态
                    var checkedStyle = $(layero).find('input[name="style"]:checked').val();
                    var checkedTitle = $(layero).find('#ai-seo-title').is(':checked');
                    var checkedKeywords = $(layero).find('#ai-seo-keywords').is(':checked');
                    var checkedDesc = $(layero).find('#ai-seo-desc').is(':checked');

                    var $desc = $(layero).find('#style-desc');
                    var checkedVal = $(layero).find('input[name="style"]:checked').val();
                    $desc.text(styleMap[checkedVal].desc);

                    // 用layui的form.on监听
                    form.on('radio(style)', function (data) {
                        $desc.text(styleMap[data.value].desc);
                        localStorage.setItem('ai_style', data.value);
                        console.log('切换风格:', data.value);
                    });
                    form.on('checkbox(ai-seo-title)', function (data) {
                        localStorage.setItem('ai_seo_title', data.elem.checked ? '1' : '0');
                        console.log('勾选标题:', data.elem.checked);
                    });
                    form.on('checkbox(ai-seo-keywords)', function (data) {
                        localStorage.setItem('ai_seo_keywords', data.elem.checked ? '1' : '0');
                        console.log('勾选关键词:', data.elem.checked);
                    });
                    form.on('checkbox(ai-seo-desc)', function (data) {
                        localStorage.setItem('ai_seo_desc', data.elem.checked ? '1' : '0');
                        console.log('勾选描述:', data.elem.checked);
                    });

                    // 实时保存输入
                    $(layero).find('#ai-prompt').on('input', function () {
                        localStorage.setItem('ai_prompt', $(this).val());
                    });
                    $(layero).find('#ai-wordcount').on('input', function () {
                        localStorage.setItem('ai_wordcount', $(this).val());
                    });

                    // 绑定AI生成按钮事件
                    $(layero).find('#ai-generate-btn').on('click', function () {
                        generateAIContent(index);
                    });
                }
            });
        });
    });


    
    function generateAIContent(layerIndex) {
            // 获取表单数据
            var prompt = $('#ai-prompt').val().trim();
            var wordCount = $('#ai-wordcount').val() || 1500;
            var generateTitle = $('#ai-seo-title').is(':checked');
            var generateKeywords = $('#ai-seo-keywords').is(':checked');
            var generateDesc = $('#ai-seo-desc').is(':checked');
            var style = $('input[name="style"]:checked').val();

            // 校验必填项
            if (!prompt) {
                layer.msg('请输入提示词！', { icon: 2, offset: '100px' });
                return false;
            }

            if (!prompt || prompt.length < 4) {
                layer.msg('提示词至少需要3个字以上！', { icon: 2, offset: '100px' });
                return false;
            }

            // 构建发送内容，加入内联样式排版要求
            var fullPrompt = prompt + '\n\n';
            fullPrompt += '文章字数要求：' + wordCount + '字左右。\n';
            if (generateTitle) fullPrompt += '请生成一个吸引人的标题。\n';
            if (generateKeywords) fullPrompt += '请生成3-5个SEO关键词，用逗号分隔。\n';
            if (generateDesc) fullPrompt += '请生成SEO描述（150字以内）。\n';

            // 根据风格选项追加风格要求
            if (styleMap[style]) {
                fullPrompt += styleMap[style].prompt + '\n';
            }
            fullPrompt += '请将正文内容用美观的排版输出，要求如下：\n';
            fullPrompt += '1. 段落用<p>标签，内联style="text-indent:2em;line-height:1.8;margin:10px 0;color:#333;font-size:15px;"。\n';
            fullPrompt += '2. 小标题用<h2>或<h3>，加粗，内联style="font-weight:bold;margin:18px 0 10px 0;color:#222;font-size:18px;"。\n';
            fullPrompt += '3. 列表用<ul>/<ol>和<li>，li内联style="margin:6px 0 6px 2em;font-size:15px;color:#333;"。\n';
            fullPrompt += '4. 强调内容用<strong>或<em>，并加style="color:#c00;font-weight:bold;"。\n';
            fullPrompt += '5. 禁止输出任何class、id、script、link、style标签。\n';
            fullPrompt += '6. 只输出HTML代码，不要任何说明和解释。\n';
            fullPrompt += '请严格在正文后用如下格式输出附加信息（不要省略分隔符和字段名，不要输出多余内容）：\n';
            fullPrompt += '---附加信息---\n';
            fullPrompt += '标题: [标题]\n';
            fullPrompt += 'SEO关键词: [关键词]\n';
            fullPrompt += 'SEO描述: [描述]\n';

            // 显示加载
            var loadingIndex = layer.msg('AI正在生成内容，请稍候...', {
                icon: 16,
                shade: 0.3,
                time: 0
            });

            // 生成session_id
            function generateUUID() {
                return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                    var r = Math.random() * 16 | 0,
                        v = c === 'x' ? r : (r & 0x3 | 0x8);
                    return v.toString(16);
                });
            }
            var session_id = generateUUID();

            // 获取编辑器实例
            function getEditor(callback) {
                if (window.UE && UE.getEditor('editor')) {
                    var editor = UE.getEditor('editor');
                    if (editor.ready) {
                        callback(editor);
                    } else {
                        editor.ready(function () {
                            callback(editor);
                        });
                    }
                } else {
                    setTimeout(function () {
                        getEditor(callback);
                    }, 100);
                }
            }

            // 内容处理函数
            function processContent(rawContent) {
                var parts = rawContent.split('---附加信息---');
                var articleContent = parts[0] || rawContent;
                articleContent = articleContent
                    .replace(/```html/g, '')
                    .replace(/```/g, '')
                    .replace(/<p>\s*```html\s*<\/p>/gi, '')
                    .replace(/<p>\s*```<\/p>/gi, '')
                    .replace(/^\s*<p>\s*<\/p>/gi, '')
                    .replace(/^(#|>|-|\*|•|●|\d+\.)\s.*$/gm, '')
                    .replace(/^\s*\n+/g, '')
                    .replace(/\n{3,}/g, '\n\n')
                    .replace(/(<p>\s*){2,}/g, '<p>')
                    .replace(/(<\/p>\s*){2,}/g, '</p>')
                    .replace(/<style[\s\S]*?<\/style>/gi, '')
                    .replace(/<script[\s\S]*?<\/script>/gi, '')
                    .replace(/<!--[\s\S]*?-->/g, '')
        .replace(/(<p>\s*)+<\/p>/gi, '')
                            .replace(/(<\/?p>\s*){2,}/gi, '</p>')
                            .replace(/^\s+|\s+$/g, '')
                            .replace(/^\n+|\n+$/g, '');
                articleContent = articleContent.replace(/^(<[^>]+>)*\s*/g, '').replace(/\s*(<\/[^>]+>)*$/g, '');
                return articleContent;
            }

            // 提取附加信息
            function extractInfo(rawContent) {
                var info = { title: '', description: '', keywords: '' };
                var match = rawContent.match(/---附加信息---([\s\S]*)$/);
                if (match) {
                    var add = match[1];
                    var t = add.match(/标题\s*[:：]\s*([^\n\r]+)/i);
                    var d = add.match(/SEO描述\s*[:：]\s*([^\n\r]+)/i);
                    var k = add.match(/SEO关键词\s*[:：]\s*([^\n\r]+)/i);
                    if (t) info.title = t[1].trim();
                    if (d) info.description = d[1].trim();
                    if (k) info.keywords = k[1].trim().replace(/，/g, ',');
                }
                return info;
            }

            // 判断有效性，防止占位内容
            function isValid(val, type) {
                if (!val) return false;
                if (type === 'title' && /^\s*(\[?标题\]?|title)\s*$/i.test(val)) return false;
                if (type === 'keywords' && /^\s*(\[?关键词\]?|keywords)\s*$/i.test(val)) return false;
                if (type === 'description' && /^\s*(\[?描述\]?|description)\s*$/i.test(val)) return false;
                return true;
            }

            // 发送请求到AI接口
            fetch('https://wss.lke.cloud.tencent.com/v1/qbot/chat/sse', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    content: fullPrompt,
                    session_id: session_id,
                    bot_app_key: "JHtuHqzf"
                })
            })
                .then(async response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    const reader = response.body.getReader();
                    const decoder = new TextDecoder('utf-8');
                    let aiContentBuffer = '';
                    let lastContent = '';
                    let lastInfo = { title: '', keywords: '', description: '' };

                    getEditor(function (editor) {
                        editor.setContent(''); // 先清空
                        async function streamReply() {
                            while (true) {
                                const { done, value } = await reader.read();
                                if (done) break;
                                const chunk = decoder.decode(value, { stream: true });
                                const lines = chunk.split('\n');
                                for (let line of lines) {
                                    if (line.startsWith('data:')) {
                                        try {
                                            const dataStr = line.replace('data:', '').trim();
                                            if (dataStr && dataStr !== '[DONE]') {
                                                const json = JSON.parse(dataStr);
                                                if (json.payload && json.payload.content) {
                                                    aiContentBuffer = json.payload.content;

                                                    // 实时提取正文和附加信息
                                                    var content = processContent(aiContentBuffer);
                                                    var info = extractInfo(aiContentBuffer);

                                                    // 逐字流式显示正文内容
                                                    if (content && content !== lastContent) {
                                                        lastContent = content;
                                                        editor.setContent(content);
                                                    }

                                                    // 实时赋值到主表单，仅赋有效内容
                                                    var mainForm = document.querySelector('form.layui-form');
                                                    if (mainForm) {
                                                        if (generateTitle && isValid(info.title, 'title') && info.title !== lastInfo.title) {
                                                            var titleInput = mainForm.querySelector('input[name="title"]');
                                                            if (titleInput) titleInput.value = info.title;
                                                            lastInfo.title = info.title;
                                                        }
                                                        if (generateKeywords && isValid(info.keywords, 'keywords') && info.keywords !== lastInfo.keywords) {
                                                            var keywordsInput = mainForm.querySelector('input[name="keywords"]');
                                                            if (keywordsInput) keywordsInput.value = info.keywords;
                                                            lastInfo.keywords = info.keywords;
                                                        }
                                                        if (generateDesc && isValid(info.description, 'description') && info.description !== lastInfo.description) {
                                                            var descInput = mainForm.querySelector('textarea[name="description"]');
                                                            if (descInput) descInput.value = info.description;
                                                            lastInfo.description = info.description;
                                                        }
                                                    }
                                                }
                                            }
                                        } catch (e) { }
                                    }
                                }
                            }
                            // 重点：流式结束后再做一次最终赋值，确保完整
                            var content = processContent(aiContentBuffer);
                            var info = extractInfo(aiContentBuffer);
                            editor.setContent(content);

                            // 精准赋值到当前tab下的input/textarea，仅勾选项且内容有效才赋值
                            function setInputValue(name, value) {
                                var $input = $('div.layui-tab-item.layui-show [name="' + name + '"]');
                                if ($input.length) {
                                    $input.val(value);
                                } else {
                                    $('form.layui-form [name="' + name + '"]').first().val(value);
                                }
                            }

                            if (generateTitle && isValid(info.title, 'title')) setInputValue('title', info.title);
                            if (generateKeywords && isValid(info.keywords, 'keywords')) setInputValue('keywords', info.keywords);
                            if (generateDesc && isValid(info.description, 'description')) setInputValue('description', info.description);

                            // 关闭AI侧边弹窗和loading
                            layer.close(loadingIndex);
                            if (typeof layerIndex !== 'undefined') {
                                layer.close(layerIndex);
                            }

                            // AI生成成功后清空本地存储
                            localStorage.removeItem('ai_prompt');
                            localStorage.removeItem('ai_wordcount');
                            localStorage.removeItem('ai_style');
                            localStorage.removeItem('ai_seo_title');
                            localStorage.removeItem('ai_seo_keywords');
                            localStorage.removeItem('ai_seo_desc');

                            // 弹窗显示生成的标题/关键词/描述
                            if (
                                (generateTitle && isValid(info.title, 'title')) ||
                                (generateKeywords && isValid(info.keywords, 'keywords')) ||
                                (generateDesc && isValid(info.description, 'description'))
                            ) {
                                let html = '<div style="padding:20px 30px 10px 30px;font-size:15px;">';
                                if (generateTitle && isValid(info.title, 'title')) {
                                    html += '<div style="margin-bottom:10px;"><b>标题：</b>' + $('<div>').text(info.title).html() + '</div>';
                                }
                                if (generateKeywords && isValid(info.keywords, 'keywords')) {
                                    html += '<div style="margin-bottom:10px;"><b>关键词：</b>' + $('<div>').text(info.keywords).html() + '</div>';
                                }
                                if (generateDesc && isValid(info.description, 'description')) {
                                    html += '<div style="margin-bottom:10px;"><b>描述：</b>' + $('<div>').text(info.description).html() + '</div>';
                                }
                                html += '</div>';
                                layer.open({
                                    type: 1,
                                    title: 'AI已生成并赋值',
                                    area: '420px',
                                    shadeClose: true,
                                    btn: ['确定'],
                                    content: html,
                                    yes: function(index) {
                                        layer.close(index);
                                    }
                                });
                            } else {
                                layer.msg('AI内容已生成完成！', { icon: 1, offset: '100px' });
                            }
                        }
                        streamReply();
                    });
                })
                .catch(error => {
                    layer.close(loadingIndex);
                    layer.msg('请求失败：' + error.message, { icon: 5, offset: '100px' });
                });
        }

  