<?php

// 检测PHP环境
if (phpversion() < '8.0') {
    header("Content-type:text/html;charset=utf-8");
    die('系统要求PHP版本 >= 8.0，当前PHP版本为：'.phpversion() . '，请到虚拟主机控制面板里切换PHP版本，或联系空间商协助切换。');
}

// 检测是否已安装lgcms系统
if (file_exists('./install.lock')) {
    echo '
        <html>
        <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        </head>
        <body>
            你已经安装过系统，如果想重新安装，请先删除install目录下的 install.lock 文件，然后再安装。<a href="/">返回首页</a>
        </body>
        </html>';
    exit;
}

// 处理安装表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? '';
    $db_name = $_POST['db_name'] ?? '';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    $db_port = $_POST['db_port'] ?? '3306';
    $admin_user = $_POST['admin_user'] ?? '';
    $admin_pass = $_POST['admin_pass'] ?? '';

    // 基本校验
    if (!$db_host || !$db_name || !$db_user || !$db_port || !$admin_user || !$admin_pass) {
        header('Content-Type: text/html; charset=utf-8');
        echo '参数不完整，请返回重试。';
        exit;
    }

    // 创建数据库连接
    mysqli_report(MYSQLI_REPORT_OFF);
    $mysqli = @new mysqli($db_host, $db_user, $db_pass, null, (int)$db_port);
    if ($mysqli->connect_errno) {
        header('Content-Type: text/html; charset=utf-8');
        echo '数据库连接失败：' . $mysqli->connect_error;
        exit;
    }

    // 创建数据库
    $dbNameEsc = $mysqli->real_escape_string($db_name);
    $createDbSql = "CREATE DATABASE IF NOT EXISTS `{$dbNameEsc}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    if (!$mysqli->query($createDbSql)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '创建数据库失败：' . $mysqli->error;
        exit;
    }

    // 选择数据库
    if (!$mysqli->select_db($db_name)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '选择数据库失败：' . $mysqli->error;
        exit;
    }

    // 如果数据库有表，则清空
    if ($res = $mysqli->query('SHOW TABLES')) {
        while ($row = $res->fetch_array(MYSQLI_NUM)) {
            $tbl = $row[0];
            $mysqli->query("DROP TABLE IF EXISTS `{$tbl}`");
        }
        $res->free();
    }

    // 导入 SQL 文件
    $sqlFile = __DIR__ . DIRECTORY_SEPARATOR . 'lgcms.sql';
    if (!file_exists($sqlFile)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '找不到数据库文件：install/lgcms.sql';
        exit;
    }
    $sql = file_get_contents($sqlFile);
    if ($sql === false) {
        header('Content-Type: text/html; charset=utf-8');
        echo '读取数据库文件失败。';
        exit;
    }

    // 去除注释并按分号拆分语句
    $lines = preg_split('/\r?\n/', $sql);
    $clean = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '' || strpos($line, '--') === 0 || strpos($line, '/*') === 0) continue;
        $clean[] = $line;
    }
    $sqlClean = implode("\n", $clean);
    $statements = array_filter(array_map('trim', preg_split('/;\s*\n|;\r?\n|;$/m', $sqlClean)));

    foreach ($statements as $statement) {
        if ($statement === '') continue;
        if (!$mysqli->query($statement)) {
            header('Content-Type: text/html; charset=utf-8');
            echo '执行 SQL 失败：' . htmlspecialchars($mysqli->error) . '<br>语句：' . htmlspecialchars($statement);
            exit;
        }
    }

    // 更新管理员账号密码
    $admin_user_esc = $mysqli->real_escape_string($admin_user);
    $admin_pass_hash = md5($admin_pass);
    $updateAdminSql = "UPDATE `admin` SET `adname`='{$admin_user_esc}', `password`='{$admin_pass_hash}' WHERE `id`=1";
    if (!$mysqli->query($updateAdminSql)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '更新管理员账号失败：' . $mysqli->error;
        exit;
    }

    // 写入数据库配置文件（精简且保留原有格式，仅改 env() 默认值）
    $dbConfigPath = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'database.php';
    if (!is_file($dbConfigPath)) {
        header('Content-Type: text/html; charset=utf-8');
        echo '未找到数据库配置文件：' . htmlspecialchars($dbConfigPath);
        exit;
    }

    $code = file_get_contents($dbConfigPath);
    if ($code === false) {
        header('Content-Type: text/html; charset=utf-8');
        echo '读取数据库配置文件失败。';
        exit;
    }

    // 仅替换 env('KEY', '默认值') 的第二参数；不改动排版与注释
    $replaceEnvDefault = function (string $src, string $key, string $val): string {
        $pattern = '/(env\(\s*([\'"])' . preg_quote($key, '/') . '\2\s*,\s*)([\'"])(.*?)(\3)(\s*\))/i';
        return preg_replace_callback($pattern, function ($m) use ($val) {
            $q = $m[3];
            // 按原引号类型转义
            if ($q === "'") {
                $v = str_replace(["\\", "'"], ["\\\\", "\\'"], $val);
            } else {
                $v = str_replace(["\\", '"'], ["\\\\", '\\"'], $val);
            }
            return $m[1] . $q . $v . $q . $m[6];
        }, $src, 1) ?? $src; // 每个键替一次
    };

    // 需要覆盖的键
    $map = [
        'DB_DRIVER'  => 'mysql',
        'DB_TYPE'    => 'mysql',
        'DB_HOST'    => $db_host,
        'DB_NAME'    => $db_name,
        'DB_USER'    => $db_user,
        'DB_PASS'    => $db_pass,
        'DB_PORT'    => (string)$db_port,
        'DB_CHARSET' => 'utf8mb4',
        // 如需表前缀：'DB_PREFIX' => 'lg_',
    ];

    foreach ($map as $k => $v) {
        $code = $replaceEnvDefault($code, $k, $v);
    }

    if (file_put_contents($dbConfigPath, $code, LOCK_EX) === false) {
        header('Content-Type: text/html; charset=utf-8');
        echo '写入数据库配置失败：' . htmlspecialchars($dbConfigPath);
        exit;
    }


    // 生成 install.lock
    if (file_put_contents(__DIR__ . DIRECTORY_SEPARATOR . 'install.lock', 'installed') === false) {
        header('Content-Type: text/html; charset=utf-8');
        echo '创建 install.lock 失败';
        exit;
    }

    // 显示成功页
    include_once  'template/step2.php';
    exit;
}

// 默认显示安装页
include_once  'template/step1.php';


