<?php
declare (strict_types = 1);

namespace app\home\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;
use think\facade\Session;

class Index extends Common
{
    
    // 空拦截器, 实现文章路由转发
    public function _empty(Request $request)
    {   
        // sitemap 延迟生成已在 Common::initialize 中统一触发

        // 获取链接
        $url = $_SERVER['REQUEST_URI'];
       
        // 获取基本参数
        $config = Db::name('config')->where('id', 1)->find();

        // 拆分URL路径
        $result = array_values(array_filter(explode('/', $url)));

        // 判断当前路径结果有几组数据
        if (count($result) > 1) {
            //内容详情或者搜索情况
            $id = str_replace('.html', '', $result[1] ?? '');
            $content = Db::name('content')->where('id', $id)->whereor('filename', $id)->find();
            $category = Db::name('category')->where('id', $content['scode'])->find();
            $this->getContent($id);
            return $this->renderForDevice($this->cleanFilename($category['contenttpl']), $config);
        }
     
        // 处理搜索请求
        if (strpos($result[0], 'search') !== false) {
            // 解析URL参数
            if (strpos($result[0], '?') !== false) {
                $parts = explode('?', $result[0]);
                parse_str($parts[1], $params);
                $keyword = isset($params['keyword']) ? $params['keyword'] : '';
            } else {
                $keyword = $request->param('keyword', '');
            }
            $this->getSearch($keyword);
            return $this->renderForDevice('search', $config);
        }

        // 处理分页URL，如 products_2
        if (preg_match('#^([a-zA-Z0-9\-_]+)_(\d+)/?$#', $result[0], $matches)) {
            $categoryFilename = $matches[1];
            $page = intval($matches[2]);

            //link拼接
            $link='/'.$categoryFilename.'/';
            
            // 根据filename查找栏目
            $sort = Db::name('category')->where('filename', $categoryFilename)->whereOr('link', $link)->find();
            if ($sort) {
                $this->getList($sort);
                View::assign('current_page', $page);
                
                // 获取栏目模型
                $model = Db::name('model')->where('id', $sort['model'])->find();
                
                return $this->renderForDevice($this->cleanFilename($sort['listtpl']), $config);
            }
        }
        

        //栏目页
        $filename = str_replace('.html', '', $result[0] ?? '');

        //link拼接
        $link='/'.$filename.'/';

        //获取栏目
        $sort = Db::name('category')->where('filename', $filename)->whereOr('link', $link)->find();
       
        // 获取栏目模型
        $model = Db::name('model')->where('id', $sort['model'])->find();
      
        // '1'单页模型,'2列表模型
        if ($model['type'] == '1') {
            $this->getAbout($sort);
            return $this->renderForDevice($this->cleanFilename($sort['contenttpl']), $config);
        }elseif ($model['type'] == '2') {
            $this->getList($sort);
            return $this->renderForDevice($this->cleanFilename($sort['listtpl']), $config);
        }
        
        // 默认返回404
        return View::fetch('404.html');
    }

    public function data(){
        $data = Db::name('system')->where('id',1)->find();
        return json($data);
    }

    // 首页
    public function index()
    {
        // sitemap 延迟生成已在 Common::initialize 中统一触发
        //站点信息
        $system=Db::name('system')->where('id',1)->find();
        $long=Db::name('system')->where('id',1)->find();
        //配置参数
        $config=Db::name('config')->where('id',1)->find();

        // SEO信息处理
        $long['title']=$system['title'];
        $long['keywords']=$system['keywords'];
        $long['description']=$system['description'];

    
        View::assign([
            'long'=>$long,
        ]);

        //判断是否有单独手机端
        if($config['open_wap']==1){
            if(request()->isMobile()){
                //判断是否有设置过手机端域名
                if($config['wap_domain']!=''){
                    // 检查域名是否包含http前缀，没有则添加
                    $wapUrl = preg_match('/^https?:\/\//i', $config['wap_domain']) ? 
                            $config['wap_domain'] : 'http://'.$config['wap_domain'];
                    header("Location: $wapUrl");
                    exit;
                }
                return View::fetch('/wap/index');
            }else{
                return View::fetch('index/index');
            }
        }
        return View::fetch('index/index');
    }

    // 单页
    public function getAbout($sort)
    {
        // 获取配置参数及顶级栏目
        $system=Db::name('system')->where('id',1)->find();
        $long=Db::name('system')->where('id',1)->find();
        $cate=$this->getTopCategory($sort['id']);

        // 获取单页内容和自定义标签
        $content = Db::name('single')->where(['scode' => $sort['id']])->find();
        $single_ext = Db::name('single_ext')->where(['single' => $sort['id']])->select()->toArray();
        $content['single_ext'] = array_column($single_ext, 'value', 'field');

        // SEO信息处理及面包屑
        $long['title']=$sort['title']?$sort['title'] : $sort['name'] . '-' . $system['title'];
        $long['keywords'] = !empty($sort['keywords']) ? $sort['keywords'] : $system['keywords'];
        $long['description'] = !empty($sort['description']) ? $sort['description'] : $system['description'];
        $long['position'] = $this->buildBreadcrumb($sort['id']);

        // 获取当前栏目扩展字段
        $category_ext = Db::name('category_ext')->where(['category' => $sort['id']])->select()->toArray();
        $sort['ext'] = array_column($category_ext, 'value', 'field');

        // 当前栏目没有栏目图，则获取顶级栏目栏目图
        $sort['pic'] = !empty($sort['pic']) ? $sort['pic'] : $cate['pic'];

        // 输出到模板
        View::assign([
            'long'=>$long,
            'cate'=>$cate,
            'sort'=>$sort,
            'content'=>$content,
        ]);
       
    }


    // 列表页
    public function getList($sort)
    {
        // 获取配置参数及顶级栏目
        $system = Db::name('system')->where('id', 1)->find();
        $long = Db::name('system')->where('id', 1)->find();
        $cate = $this->getTopCategory($sort['id']);

        // 获取当前页码
        $page = request()->param('page/d', 1);

        // SEO信息处理及面包屑
        $long['title'] = !empty($sort['title']) ? $sort['title'] : $sort['name'] . '-' . $system['title'];
        if ($page > 1) {
            $long['title'] .= " - 第{$page}页";
        }
        $long['keywords'] = !empty($sort['keywords']) ? $sort['keywords'] : $system['keywords'];
        $long['description'] = !empty($sort['description']) ? $sort['description'] : $system['description'];
        $long['position'] = $this->buildBreadcrumb($sort['id']);

        // 传递分页相关信息
        $long['page'] = $page;

        // 获取当前栏目扩展字段
        $category_ext = Db::name('category_ext')->where(['category' => $sort['id']])->select()->toArray();
        $sort['ext'] = array_column($category_ext, 'value', 'field');

        // 当前栏目没有栏目图，则获取顶级栏目栏目图
        $sort['pic'] = !empty($sort['pic']) ? $sort['pic'] : $cate['pic'];

        // 输出到模板
        View::assign([
            'long' => $long,
            'cate' => $cate,
            'sort' => $sort,
            'current_page' => $page, // 明确传递当前页码
        ]);
    }


    // 详情页
    public function getContent($id)
    {
       
        // 获取详情内容和自定义标签
        
        $content = Db::name('content')->where('id',$id)->whereOr('filename',$id)->find();
        
        $content_ext = Db::name('content_ext')->where(['content'=>$content['id']])->select()->toArray();
        $content['ext'] = array_column($content_ext, 'value', 'field');
        Db::name('content')->where(['id'=>$content['id']])->inc('click', 1)->update();

        // 获取配置参数及顶级栏目
        $system=Db::name('system')->where('id',1)->find();
        $long=Db::name('system')->where('id',1)->find();
        $cate=$this->getTopCategory($content['scode']);

        // SEO信息处理及面包屑
        $long['title']=$content['title'] . '-' . $system['title'];
        $long['keywords'] = !empty($content['keywords']) ? $content['keywords'] : $system['keywords'];
        $long['description'] = !empty($content['description']) ? $content['description'] : $system['description'];
        $long['position'] = $this->buildBreadcrumb($content['scode'], $content['title']);
      
        // 当前栏目没有栏目图，则获取顶级栏目栏目图
        $sort=Db::name('category')->where('id',$content['scode'])->find();
        
        // 获取当前栏目扩展字段
        $category_ext = Db::name('category_ext')->where(['category' => $sort['id']])->select()->toArray();
        $sort['ext'] = array_column($category_ext, 'value', 'field');
        
        $sort['pic'] = !empty($sort['pic']) ? $sort['pic'] : $cate['pic'];

        //上一条及下一条
        $content_prev=Db::name('content')->where('status',1)->where('id','<',$content['id'])->where(['scode'=>$content['scode']])->order('id desc')->limit(1)->find();
        $content_next=Db::name('content')->where('status',1)->where('id','>',$content['id'])->where(['scode'=>$content['scode']])->order('id asc')->limit(1)->find();
        if($content_prev){
            $content['prevtitle'] = ''. $content_prev['title'] .'';
            $content['prevlink'] = ''. $content_prev['link'] .'';
        }else{
            $content['prevtitle'] = '没有了！';
            $content['prevlink'] = 'javascript:;';
        }
        if($content_next){
            $content['nexttitle'] = ''. $content_next['title'] .'';
            $content['nextlink'] = ''. $content_next['link'] .'';
        } else {
            $content['nexttitle'] = '没有了！';
            $content['nextlink'] = 'javascript:;';
        }
        
        //判断详情权限
        if(!$content['gid']==''){
            echo '<script>window.location.href="/login/"</script>';
        }
        
        View::assign([
            'long'=>$long,
            'cate'=>$cate,
            'sort'=>$sort,
            'content'=>$content,
        ]);
    }

    // 搜索页
    public function getSearch($keyword)
    {
        //站点信息及配置参数
        $system=Db::name('system')->where('id',1)->find();
        $long=Db::name('system')->where('id',1)->find();
        $config=Db::name('config')->where('id',1)->find();
        $model=explode(',',$config['search']);
       
        //搜索内容数量
        $count=Db::name('content')->where('status',1)->where('model','in',$model)->where('title','like','%'.$keyword.'%')->order('sort asc,id desc')->count();  

        // 获取标题，如果没有设置标题则使用名称
        $long['title']=$keyword.'-搜索结果'.'-'.$system['title'];
        $long['keywords']=$system['keywords'];
        $long['description']=$system['description'];
        $long['keyword']=$keyword;
      
        View::assign([
            'long'=>$long,
            'count'=>$count,
            'keyword'=>$keyword,
        ]);
    }

    // 留言
    public function msg()
    {
        //配置参数
        $config=Db::name('config')->where('id',1)->find();

        // 判断是否关闭留言功能
        if($config['message_status']=='0'){
            return json(['status' => 'fail', 'msg' => '系统已经关闭表单功能，请到后台开启再试！']);
        }

        // 获取提交的数据
        $data=input('post.');
        $form_id=input('fcode');
        $time=time();
        
        // 检查用户是否在 10 秒内重复提交
        $lastSubmitTime = Session::get('last_submit_time');
        if ($lastSubmitTime && ($time - $lastSubmitTime < 10)) {
            return json(['status' => 'fail', 'msg' => '您提交太频繁了，请稍后再试！']);
        }

        // 更新上次提交时间
        Session::set('last_submit_time', $time);

        // 获取用户 IP
        $ip = request()->ip();

        // 获取用户浏览器
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
        $browser = $this->getBrowser($userAgent);

        // 获取操作系统信息
        $os = $this->getOS($userAgent);

    
        $date = Db::name('msg')->where('ip', $ip)->find();

        $ip_addr='';
        if ($date) {
            // 如果当天已记录，直接用已有的ip_addr
            $ip_addr = $date['ip_addr'];
        } else {
            // 获取IP地址信息
            if ($ip === '127.0.0.1' || $ip === '::1') {
                $ip_addr = '本地';
            } else {
                $url = "http://whois.pconline.com.cn/ipJson.jsp?ip={$ip}&json=true";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
                $ipJson = curl_exec($ch);
                curl_close($ch);

                // 转码为UTF-8
                $ipJson = mb_convert_encoding($ipJson, 'UTF-8', 'GBK');
                $ipData = json_decode($ipJson, true);
                if ($ipData && isset($ipData['pro']) && isset($ipData['city'])) {
                    if (empty($ipData['pro']) && empty($ipData['city']) && !empty($ipData['addr'])) {
                        $ip_addr = $ipData['addr'];
                    } else {
                        $ip_addr = $ipData['pro'] . $ipData['city'];
                    }
                } else {
                    $ip_addr = '';
                }
                if (empty($ip_addr)) {
                    $ip_addr = '未知';
                }
            }
        }

        $information='IP：'.$ip.'；' .'地区：'.$ip_addr.'；' .  '浏览器：'.$browser.'；'. '操作系统：'.$os;

        // 获取当前最大的 sign 值
        $maxSign = Db::name('msg')->max('sign');
        
        // 准备邮件内容（只有在需要发送邮件时才准备）
        $emailContent = [];
        if ($config['message_send_mail'] == '1') {
            $emailContent[] = "收到新的留言，详情如下：\n";
            $emailContent[] = "时间：" . date('Y-m-d H:i:s', $time);
            $emailContent[] = "IP地址：" . $ip;
            $emailContent[] = "地区：" . $ip_addr;
            $emailContent[] = "浏览器：" . $browser;
            $emailContent[] = "操作系统：" . $os;
            $emailContent[] = "\n留言内容：";
        }
        
        foreach($data as $k=>$v){
            $fcode=Db::name('fcode')->where('form_id',$form_id)->where('name',$k)->find();
            
            // 保存到数据库
            Db::name('msg')->strict(false)->insert([
                'sign'=>$maxSign + 1,
                'form_id'=>$form_id,
                'name'=>$fcode['description'],
                'field'=>$k,
                'value'=>$v,
                'time'=>$time,
                'ip'=>$ip,
                'ip_addr'=>$ip_addr,
                'information'=>$information
            ]);
            
            // 添加到邮件内容（只有在需要发送邮件时才添加）
            if ($config['message_send_mail'] == '1') {
                $fieldDesc = $fcode['description'] ?? $k;
                $emailContent[] = $fieldDesc . "：" . $v;
            }
        }
        
        // 判断是否需要发送邮件通知
        if ($config['message_send_mail'] == '1') {
            $this->sendEmailNotification(implode("\n", $emailContent));
        }
        
        return json(['status'=>'success','msg'=>'留言成功！']);
    }

    /**
     * 发送邮件通知
     * @param string $content 邮件内容
     */
    private function sendEmailNotification($content)
    {
        //配置参数
        $config=Db::name('config')->where('id',1)->find();
        try {
            // 邮件配置 - 请根据实际情况修改
            $smtpHost = $config['smtp_server'];  // QQ邮箱SMTP服务器
            $smtpPort = !empty($config['smtp_port']) ? intval($config['smtp_port']) : 587;  // 动态端口，默认587
            $smtpUsername = $config['smtp_username'];  // 发送方QQ邮箱
            $smtpPassword = $config['smtp_password'];  // QQ邮箱授权码（不是QQ密码）
            $toEmail = $config['message_send_to'];   // 接收通知的邮箱
            
            // 创建邮件头
            $subject = "网站新留言通知 - " . date('Y-m-d H:i:s');
            $headers = [
                'From: ' . $smtpUsername,
                'Reply-To: ' . $smtpUsername,
                'X-Mailer: PHP/' . phpversion(),
                'MIME-Version: 1.0',
                'Content-Type: text/plain; charset=UTF-8'
            ];
            
            // 使用SMTP发送邮件
            $this->sendSMTPMail($smtpHost, $smtpPort, $smtpUsername, $smtpPassword, $toEmail, $subject, $content);
            
        } catch (Exception $e) {
            // 记录错误日志，但不影响留言功能
            error_log('邮件发送失败: ' . $e->getMessage());
        }
    }

    /**
     * SMTP邮件发送
     */
    private function sendSMTPMail($host, $port, $username, $password, $to, $subject, $body)
    {
        // 根据端口选择连接方式
        if ($port == 465) {
            // SSL连接
            $socket = fsockopen('ssl://' . $host, $port, $errno, $errstr, 30);
        } else {
            // 普通连接（587端口会后续升级为TLS）
            $socket = fsockopen($host, $port, $errno, $errstr, 30);
        }
        
        if (!$socket) {
            throw new Exception("无法连接到SMTP服务器: $errstr ($errno)");
        }
        
        // 读取服务器欢迎消息
        $this->getResponse($socket);
        
        // EHLO握手
        fwrite($socket, "EHLO localhost\r\n");
        $this->getResponse($socket);
        
        // 如果是587端口，启用STARTTLS
        if ($port == 587) {
            fwrite($socket, "STARTTLS\r\n");
            $response = $this->getResponse($socket);
            
            // 启用TLS加密
            $crypto_method = STREAM_CRYPTO_METHOD_TLS_CLIENT;
            if (defined('STREAM_CRYPTO_METHOD_TLSv1_2_CLIENT')) {
                $crypto_method = STREAM_CRYPTO_METHOD_TLSv1_2_CLIENT;
            }
            
            if (!stream_socket_enable_crypto($socket, true, $crypto_method)) {
                fclose($socket);
                throw new Exception("无法启用TLS加密连接");
            }
            
            // TLS握手后重新EHLO
            fwrite($socket, "EHLO localhost\r\n");
            $this->getResponse($socket);
        }
        
        // AUTH LOGIN认证
        fwrite($socket, "AUTH LOGIN\r\n");
        $this->getResponse($socket);
        
        // 发送用户名
        fwrite($socket, base64_encode($username) . "\r\n");
        $this->getResponse($socket);
        
        // 发送密码
        fwrite($socket, base64_encode($password) . "\r\n");
        $this->getResponse($socket);
        
        // 设置发送方
        fwrite($socket, "MAIL FROM: <$username>\r\n");
        $this->getResponse($socket);
        
        // 设置接收方
        fwrite($socket, "RCPT TO: <$to>\r\n");
        $this->getResponse($socket);
        
        // 开始邮件数据
        fwrite($socket, "DATA\r\n");
        $this->getResponse($socket);
        
        // 邮件头和内容
        $mail_data = "From: $username\r\n";
        $mail_data .= "To: $to\r\n";
        $mail_data .= "Subject: =?UTF-8?B?" . base64_encode($subject) . "?=\r\n";
        $mail_data .= "MIME-Version: 1.0\r\n";
        $mail_data .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $mail_data .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
        $mail_data .= $body . "\r\n";
        $mail_data .= ".\r\n";
        
        fwrite($socket, $mail_data);
        $this->getResponse($socket);
        
        // 退出
        fwrite($socket, "QUIT\r\n");
        $this->getResponse($socket);
        
        fclose($socket);
    }

    /**
     * 获取SMTP服务器响应
     */
    private function getResponse($socket)
    {
        $response = '';
        while (($line = fgets($socket, 515)) !== false) {
            $response .= $line;
            // SMTP响应以空格结尾表示结束，以-连接表示多行响应继续
            if (isset($line[3]) && $line[3] == ' ') {
                break;
            }
        }
        
        $code = substr($response, 0, 3);
        if ($code >= '400') {
            throw new Exception("SMTP错误 ($code): $response");
        }
        
        return $response;
    }

    /**
     * 根据设备类型渲染视图
     * 
     * @param string $template 模板名称
     * @param array $config 配置信息
     * @return mixed 渲染后的视图
     */
    private function renderForDevice($template, $config)
    {
        // 检查是否开启移动端并且当前是移动设备
        if ($config['open_wap'] == 1 && request()->isMobile()) {
            // 如果设置了移动端域名，则重定向
            if (!empty($config['wap_domain'])) {
                $wapUrl = preg_match('/^https?:\/\//i', $config['wap_domain']) ? 
                    $config['wap_domain'] : 'http://'.$config['wap_domain'];
                header("Location: $wapUrl");
                exit;
            }
            // 否则使用移动端模板
            return View::fetch('/wap/'.$template);
        }
        
        // 默认使用PC端模板
        return View::fetch($template);
    }

    /**
     * 从文件名中去除.html后缀
     * 
     * @param string $filename 文件名
     * @return string 处理后的文件名
     */
    private function cleanFilename($filename)
    {
        return str_replace('.html', '', $filename);
    }

    /**
     * 从请求中提取内容ID
     * 
     * @param Request $request 请求对象
     * @param string $url URL参数
     * @return string 内容ID
     */
    private function extractContentId($request, $url)
    {
        // 获取路径信息
        $pathinfo = $request->pathinfo();
        
        // 查找最后一个斜杠后面的内容
        $lastSegment = strrchr($pathinfo, '/');
        
        if ($lastSegment) {
            // 移除开头的斜杠
            $lastSegment = substr($lastSegment, 1);
        } else {
            // 如果没有斜杠，使用整个路径
            $lastSegment = $pathinfo;
        }
        
        // 去除 .html 后缀
        $contentId = str_replace('.html', '', $lastSegment);
        
        // 确保是有效的内容ID
        if (is_numeric($contentId) || preg_match('/^[a-zA-Z0-9\-_]+$/', $contentId)) {
            return $contentId;
        }
        
        // 回退方案：检查是否有明确的内容ID参数
        $params = $request->param();
        if (isset($params['id'])) {
            return $params['id'];
        }
        
        return '';
    }


    /**
     * 获取顶级栏目
     * @param int $categoryId 当前分类ID
     * @return array 顶级栏目数据
     */
    private function getTopCategory($categoryId)
    {
        $category=Db::name('category')->where('id',$categoryId)->find();
        while($category && $category['pid']!=0){
            $category=Db::name('category')->where('id',$category['pid'])->find();
        }
        return $category;
    }

    /**
     * 构建面包屑导航 - 支持无限级分类
     * @param int $categoryId 当前分类ID
     * @param string $contentName 内容标题(可选)
     * @return string 格式化的面包屑HTML
     */
    public function buildBreadcrumb($categoryId,$contentName='')
    {
        // 获取配置参数
        $config=Db::name('config')->where('id',1)->find();
        $symbol=$config['symbol']??' &gt; '; // 默认分隔符
        
        // 初始化面包屑数组，首页为第一个元素
        $breadcrumbs=[
            ['name'=>$config['indexname']??'首页','link'=>'/']
        ];
        
        // 递归获取所有父级分类
        $this->getParentCategories($categoryId,$breadcrumbs);
        
        
        // 构建HTML
        $html='';
        $count=count($breadcrumbs);
        
        foreach($breadcrumbs as $index=>$item){
            if(empty($item['link'])){
                $html.=$item['name'];
            }else{
                $html.='<a href="'.$item['link'].'">'.$item['name'].'</a>';
            }
            
            // 添加分隔符，最后一个元素后不添加
            if($index<$count-1){
                $html.=$symbol;
            }
        }
        
        return $html;
    }

    /**
     * 递归获取所有父级分类
     * @param int $categoryId 当前分类ID
     * @param array &$breadcrumbs 引用传递的面包屑数组
     */
    public function getParentCategories($categoryId,&$breadcrumbs)
    {
        // 获取当前分类信息
        $category=Db::name('category')->where('id',$categoryId)->find();
        if(!$category){
            return;
        }
        
        // 处理链接
        $link='';
        if(!empty($category['filename'])){
            $link='/'.$category['filename'].'/';
        }elseif(!empty($category['link'])){
            $link='/'.trim($category['link'],'/').'/';
        }
        
        // 如果有父级分类，先递归处理父级
        if($category['pid']!=0){
            $this->getParentCategories($category['pid'],$breadcrumbs);
        }
        
        // 将当前分类添加到面包屑数组
        $breadcrumbs[]=[
            'name'=>$category['name'],
            'link'=>$link
        ];
    }

    // 获取浏览器信息
    private function getBrowser($userAgent)
    {
        if (strpos($userAgent, 'MSIE') !== false || strpos($userAgent, 'Trident') !== false) {
            return 'Internet Explorer';
        } elseif (strpos($userAgent, 'Firefox') !== false) {
            return 'Firefox';
        } elseif (strpos($userAgent, 'Chrome') !== false) {
            return 'Chrome';
        } elseif (strpos($userAgent, 'Safari') !== false) {
            return 'Safari';
        } elseif (strpos($userAgent, 'Opera') !== false || strpos($userAgent, 'OPR') !== false) {
            return 'Opera';
        } else {
            return 'Other';
        }
    }

    // 获取操作系统信息
    private function getOS($userAgent)
    {
        if (preg_match('/Windows NT 10.0/i', $userAgent)) {
            return 'Windows 10';
        } elseif (preg_match('/Windows NT 6.3/i', $userAgent)) {
            return 'Windows 8.1';
        } elseif (preg_match('/Windows NT 6.2/i', $userAgent)) {
            return 'Windows 8';
        } elseif (preg_match('/Windows NT 6.1/i', $userAgent)) {
            return 'Windows 7';
        } elseif (preg_match('/Windows NT 6.0/i', $userAgent)) {
            return 'Windows Vista';
        } elseif (preg_match('/Windows NT 5.1/i', $userAgent)) {
            return 'Windows XP';
        } elseif (preg_match('/Mac OS X/i', $userAgent)) {
            return 'Mac OS X';
        } elseif (preg_match('/Linux/i', $userAgent)) {
            return 'Linux';
        } elseif (preg_match('/iPhone/i', $userAgent)) {
            return 'iPhone';
        } elseif (preg_match('/iPad/i', $userAgent)) {
            return 'iPad';
        } elseif (preg_match('/Android/i', $userAgent)) {
            return 'Android';
        } else {
            return 'Other';
        }
    }


}
