<?php
namespace app\home\controller;

use app\BaseController;
use think\Request;
use think\facade\Db;
use think\facade\View;
use think\facade\Cache;

class Common extends BaseController
{
    public function initialize()
    {       

        // 配置参数
        $config = Db::name('config')->where('id', 1)->find();

        // 检查网站状态
        if (isset($config['status']) && $config['status'] == '0') {
            // 网站关闭，显示关闭提示
            echo isset($config['close_site_note']) ? $config['close_site_note'] : '网站已关闭';
            exit;
        }

        // 站点信息
        $system = Db::name('system')->where('id', 1)->find();
        $long = $system;

        // 自定义标签 多维数组转换一维数组
        $res = Db::name('label')->order('id asc')->select()->toArray();
        $label = array_column($res, 'value', 'name');

        // 当前栏目下有多少个产品（加缓存，避免每次请求全量计算）
        if (!Cache::get('category_count_updated')) {
            $cate = Db::name('category')->where('pid', '-1')->select()->toArray();
            foreach ($cate as $k => $v) {
                $totalCount = 0;
                $cate_pid = Db::name('category')->where('pid', $v['id'])->select()->toArray();
                foreach ($cate_pid as $ks => $vs) {
                    $subTotalCount = 0;
                    $cate_pid_pid = Db::name('category')->where('pid', $vs['id'])->select()->toArray();
                    foreach ($cate_pid_pid as $ks2 => $vs2) {
                        $count = Db::name('content')->where('status', 1)->where('scode', $vs2['id'])->count();
                        Db::name('category')->where('id', $vs2['id'])->update(['count' => $count]);
                        $subTotalCount += $count;
                    }
                    $count = Db::name('content')->where('status', 1)->where('scode', $vs['id'])->count();
                    $subTotalCount += $count;
                    Db::name('category')->where('id', $vs['id'])->update(['count' => $subTotalCount]);
                    $totalCount += $subTotalCount;
                }
                $count = Db::name('content')->where('status', 1)->where('scode', $v['id'])->count();
                $totalCount += $count;
                Db::name('category')->where('id', $v['id'])->update(['count' => $totalCount]);
            }
            // 10分钟内不再重复计算
            Cache::set('category_count_updated', 1, 600);
        }


        // 获取访问来源
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
        $refererType = '直接访问';

        if (empty($referer)) {
            $refererType = '直接访问';
        } elseif (strpos($referer, 'baidu.com') !== false) {
            $refererType = '百度搜索';
        } elseif (strpos($referer, 'so.com') !== false) {
            $refererType = '360搜索';
        } elseif (strpos($referer, 'sogou.com') !== false) {
            $refererType = '搜狗搜索';
        } elseif (strpos($referer, 'google.') !== false) {
            $refererType = '谷歌搜索';
        } elseif (strpos($referer, 'bing.com') !== false) {
            $refererType = '必应搜索';
        } elseif (strpos($referer, 'sm.cn') !== false) {
            $refererType = '神马搜索';
        } elseif (strpos($referer, 'weixin.qq.com') !== false || strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'micromessenger') !== false) {
            $refererType = '微信访问';
        } elseif (strpos($referer, $_SERVER['HTTP_HOST']) !== false) {
            $refererType = '站内跳转';
        } else {
            $refererType = '外部网站';
        }


        
        // 获取用户浏览器
        $userAgent = $_SERVER['HTTP_USER_AGENT'];
        $browser = $this->getBrowser($userAgent);
        

        // 获取操作系统信息
        $os = $this->getOS($userAgent);

        // 判断当前是电脑还是手机访问
        $deviceType = $this->getDeviceType($userAgent);

        // 记录当天访问ip（过滤：设备=其他 且 浏览器=Other 且 操作系统=Other或Linux 时跳过）
        $skipIpLog = ($deviceType === '其他' && $browser === 'Other' && ($os === 'Other' || $os === 'Linux'));
        if (!$skipIpLog) {
            $ip = $_SERVER['REMOTE_ADDR'] ?? '';
            $startOfDay = date("Y-m-d 00:00:00");
            $endOfDay = date("Y-m-d 23:59:59");
            $date = Db::name('count')->where('ip', $ip)->whereBetweenTime('time', $startOfDay, $endOfDay)->find();

            $ipInfo = ['addr' => ''];
            if ($date) {
                // 如果当天已记录，直接用已有的ip_addr
                $ipInfo['addr'] = $date['ip_addr'];
            } else {
                // 获取IP地址信息
                if ($ip === '127.0.0.1' || $ip === '::1') {
                    $ipInfo['addr'] = '本地';
                } else {
                    $url = "http://whois.pconline.com.cn/ipJson.jsp?ip={$ip}&json=true";
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                    $ipJson = curl_exec($ch);
                    curl_close($ch);

                    $ipJson = $ipJson !== false ? mb_convert_encoding($ipJson, 'UTF-8', 'GBK') : '';
                    $ipData = $ipJson ? json_decode($ipJson, true) : null;
                    if ($ipData && isset($ipData['pro']) && isset($ipData['city'])) {
                        if (empty($ipData['pro']) && empty($ipData['city']) && !empty($ipData['addr'])) {
                            $ipInfo['addr'] = $ipData['addr'];
                        } else {
                            $ipInfo['addr'] = $ipData['pro'] . $ipData['city'];
                        }
                    } else {
                        $ipInfo['addr'] = '未知';
                    }
                }
                if (empty($ipInfo['addr'])) {
                    $ipInfo['addr'] = '未知';
                }
            }

            // 写入访问记录
            $data = [
                'time' => date("Y-m-d H:i:s"),
                'ip' => $ip,
                'ip_addr'=> $ipInfo['addr'],
                'browser' => $browser,
                'os' => $os,
                'device_type' => $deviceType,
                'referer_type' => $refererType
            ];
            if (!$date) {
                Db::name('count')->insert($data);
            }
        }
       
        // 栏目分类打印、支持无限极分类
        $category = $this->getCategoryTree(-1);

        // 增加导航is_dow字段，判断当前主分类下是否有子分类
        Db::name('category')->where('pid','-1')->update(['is_dow'=>'0']);
        $cate_pid=Db::name('category')->where('pid','<>','-1')->select();
        foreach($cate_pid as $k=>$v){
            Db::name('category')->where(['id'=>$v['pid']])->update(['is_dow'=>'1']);
        }

        $cate['id']='0';
        View::assign([
            'system'=>$system,
            'long'=>$long,
            'label'=>$label,
            'category'=>$category,
            'cate'=>$cate,
        ]);

        // 统一延迟 sitemap 触发入口（前台任意页面首次执行）
        // 放在 initialize 末尾，避免重复在各控制器里写
        try { (new Sitemap())->lazyGenerate(); } catch (\Throwable $e) {}
    }

    private function getCategoryTree($pid)
    {
        $categories = Db::name('category')->where('status', 1)->where('pid', $pid)->order('sort asc, id asc')->select()->toArray();
        foreach ($categories as &$category) {
            $category['category'] = $this->getCategoryTree($category['id']);
        }
        return $categories;
    }

    /**
     * 显示警告消息并返回上一页
     * @param string $message 要显示的消息
     * @return string 包含JavaScript的HTML字符串
     */
    protected function alert_back($message)
    {
        // 使用JavaScript实现弹出警告框并返回上一页
        $script = "<script>alert('" . addslashes($message) . "'); history.back();</script>";
        
        // 直接输出并终止执行
        echo $script;
        exit;
    }


    // 获取浏览器信息
    private function getBrowser($userAgent)
    {
        if (strpos($userAgent, 'MSIE') !== false || strpos($userAgent, 'Trident') !== false) {
            return 'Internet Explorer';
        } elseif (strpos($userAgent, 'Firefox') !== false) {
            return 'Firefox';
        } elseif (strpos($userAgent, 'Chrome') !== false) {
            return 'Chrome';
        } elseif (strpos($userAgent, 'Safari') !== false) {
            return 'Safari';
        } elseif (strpos($userAgent, 'Opera') !== false || strpos($userAgent, 'OPR') !== false) {
            return 'Opera';
        } else {
            return 'Other';
        }
    }

    // 获取操作系统信息
    private function getOS($userAgent)
    {
        if (preg_match('/Windows NT 10.0/i', $userAgent)) {
            return 'Windows 10';
        } elseif (preg_match('/Windows NT 6.3/i', $userAgent)) {
            return 'Windows 8.1';
        } elseif (preg_match('/Windows NT 6.2/i', $userAgent)) {
            return 'Windows 8';
        } elseif (preg_match('/Windows NT 6.1/i', $userAgent)) {
            return 'Windows 7';
        } elseif (preg_match('/Windows NT 6.0/i', $userAgent)) {
            return 'Windows Vista';
        } elseif (preg_match('/Windows NT 5.1/i', $userAgent)) {
            return 'Windows XP';
        } elseif (preg_match('/Mac OS X/i', $userAgent)) {
            return 'Mac OS X';
        } elseif (preg_match('/Linux/i', $userAgent)) {
            return 'Linux';
        } elseif (preg_match('/iPhone/i', $userAgent)) {
            return 'iPhone';
        } elseif (preg_match('/iPad/i', $userAgent)) {
            return 'iPad';
        } elseif (preg_match('/Android/i', $userAgent)) {
            return 'Android';
        } else {
            return 'Other';
        }
    }

    // 判断当前是电脑还是手机访问
    private function getDeviceType($userAgent)
    {
        $userAgent = strtolower($userAgent);
        if (preg_match('/ipad/i', $userAgent)) {
            return '平板';
        } elseif (preg_match('/tablet|nexus 7|nexus 10|xoom|sm-t|gt-p|kindle|silk/i', $userAgent)) {
            return '平板';
        } elseif (preg_match('/mobile|android|iphone|ipod|blackberry|iemobile|opera mini/i', $userAgent)) {
            return '手机';
        } elseif (preg_match('/windows nt|macintosh|linux/i', $userAgent)) {
            return '电脑';
        } else {
            return '其他';
        }
    }


    

    
}