<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;


class Single extends Common
{
   
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index($id)
    {
        $model=Db::name('model')->find($id);
        $lst=Db::name('category')->where('model',$id)->order('id asc')->select();
        $lst=tree($lst);
        View::assign([
            'model'=>$model,
            'lst'=>$lst,
        ]);
        return View::fetch('index');
        
    }
    public function undefined()
    {
    
    return View::fetch('index');
    }
   
    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function create()
    {
        $model=input('model');
        $lst=Db::name('single')->where('model',$model)->order('id asc')->select();
        $lst=tree($lst);
        View::assign([
            'lst'=>$lst,
            'model'=>$model,
        ]);
        return View::fetch('add');
    }


    public function getsingle(Request $request)
    {
       
        $limit = $request->param('limit')?$request->param('limit'):10;
        $builder = Db::name('single');
        if ($request->param('searchParams')) {
            $searchParams = json_decode($request->param('searchParams'));
            $builder->where('title', 'like', '%' .$searchParams->title . '%')->where('model',$searchParams->model);
            $table = $builder->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
            return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
        }
        $table = $builder->order('sort asc,id asc')->where(['model'=>$_GET['model']])->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }
    



    public function edit($id)
    {
        $edit=Db::name('single')->find($id);
        if($edit['pics']!==null){
            $pics=explode(',',$edit['pics']);//字符串转换数组
        }else{
            $pics='';
        }
        $single_ext=Db::name('single_ext')->where(['single'=>$edit['id']])->where(['model'=>$edit['model']])->order('sort asc, id asc')->select();
        View::assign([
            'edit'=>$edit,
            'pics'=>$pics,
            'single_ext'=>$single_ext,
        ]);
        return View::fetch('edit');
    }



    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        $data=input('post.');
        $id=$data['id'];

         // 获取数据库中的原始数据
         $originalData = Db::name('single')->where('id', $id)->find();

         // 获取 single_ext 表中的扩展字段数据
         $extFields = Db::name('single_ext')->where('single', $id)->select()->toArray();
 
         // 将扩展字段数据合并到原始数据中
         foreach ($extFields as $extField) {
             $originalData[$extField['field']] = $extField['value'];
         }

         // 比较数据是否有变化
         $hasChanges = false;
         foreach ($data as $key => $value) {

            $old = isset($originalData[$key]) ? $originalData[$key] : '';
            $old = is_null($old) ? '' : $old;
            $new = is_null($value) ? '' : $value;
            if ($old != $new) {
                $hasChanges = true;
                break;
            }
            
         }
 
         if (!$hasChanges) {
             return json(['status' => 'fail', 'msg' => '没有做任何修改']);
         }




        if (empty($data['description']) && isset($data['content']) && is_string($data['content'])) {
            // 1. 移除HTML标签
            $text = strip_tags($data['content']);
            // 2. 替换特殊空白字符为普通空格
            $text = str_replace(['&nbsp;', '　'], ' ', $text);
            // 3. 将多个连续空格替换为单个空格
            $text = preg_replace('/\s+/', ' ', $text);
            // 4. 去除首尾空白
            $text = trim($text);
            // 5. 截取适当长度
            $data['description'] = mb_substr($text, 0, 300, 'utf-8');
        }


        $single=Db::name('single')->strict(false)->where(['id'=>$data['id']])->save($data);

        $prefix = 'ext_'; // 指定的前缀 自定定义字段是带有ext_的前缀
        $result = array_filter($data, function($key) use ($prefix) {
            return strpos($key, $prefix) === 0; 
        }, ARRAY_FILTER_USE_KEY);

        if($result==null){
        }else{
            foreach($result as $k=>$v){
                $extfield=Db::name('extfield')->where('field',$k)->find();
                Db::name('single_ext')->where(['single'=>$data['id'],'field'=>$extfield['field']])->update(['value'=>$v]);
            }
        }
       
      return json(['status'=>'success','msg'=>'更新成功']);
       

        
    }

    
    public function click()
    {
        $data=input('post.');
        $click=Db::name('single')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        if($click){
            return json(['msg'=>'编辑成功','status'=>'success']);
        }else{
            return json(['msg'=>'编辑失败','status'=>'fail']);
        }
    }

  
    public function status(Request $request)
    {
		$id = $request->param('id');
		$status = $request->param('status');
		if($status){
			Db::name('single')->where('id',$id)->update(['status'=>0]);
		}else{
			Db::name('single')->where('id',$id)->update(['status'=>1]);
		}
	}



   

}
