<?php
namespace app\admin\controller;

use think\facade\Db;
use think\facade\View;
use think\Request;

class Role extends Common
{
    public function index()
    {
        if (!$this->hasPermission('role_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        return View::fetch('index');
    }

    public function getrole(Request $request)
    {
        if (!$this->hasPermission('role_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('limit')?$request->param('limit'):10;
        $table = Db::name('auth_role')->order('sort asc,id asc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }

    public function create()
    {
        if (!$this->hasPermission('role_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        return View::fetch('add');
    }

    public function save(Request $request)
    {
        if (!$this->hasPermission('role_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data = input('post.');
        $data['create_time'] = time();
        $data['permissions'] = implode(',', $data['levels']);
        $data['name'] = trim($data['name']);
        if (Db::name('auth_role')->where('name', $data['name'])->find()) {
            return json(['status' => 'fail', 'msg' => '角色已存在']);
        }
        $roleId = Db::name('auth_role')->strict(false)->insertGetId($data);
        if ($roleId) {
            $name = isset($data['name']) ? $data['name'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : '';
            $this->logAction('添加角色设置，ID:' . $roleId . '，角色名称:' . $name . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '添加成功']);
        } else {
            return json(['status' => 'fail', 'msg' => '添加失败']);
        }
    }

   
    public function edit($id)
    {
        if (!$this->hasPermission('role_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑权限！</div>';
        }
        
        $edit=Db::name('auth_role')->find($id);
        $edit['levels'] = explode(',', $edit['permissions']);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }


    public function update()
    {
        if (!$this->hasPermission('role_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $data['permissions'] = implode(',', $data['levels']);
        $data['name'] = trim($data['name']);
        $id=$data['id'];
        $auth_role=Db::name('auth_role')->where(['id'=>$data['id']])->strict(false)->save($data);
        if($auth_role){
            $name = isset($data['name']) ? $data['name'] : '';
            $statusText = isset($data['status']) ? ($data['status'] == 1 ? '启用' : '禁用') : '';
            $this->logAction('编辑角色设置，ID:' . $data['id'] . '，角色名称:' . $name . '，状态:' . $statusText);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }

    
    public function status(Request $request)
    {
        if (!$this->hasPermission('role_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $role = Db::name('auth_role')->where('id', $id)->find();
        $name = isset($role['name']) ? $role['name'] : '';
        Db::name('auth_role')->where('id', $id)->update(['status' => $status]);
        $statusText = $status == 1 ? '启用' : '禁用';
        $this->logAction('更新角色设置，ID:' . $id . '，角色名称:' . $name . '，状态:' . $statusText);
        return json(['status' => 'success', 'msg' => '状态已更新']);
    }


    public function click()
    {
        if (!$this->hasPermission('role_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
    $data=input('post.');
    Db::name('auth_role')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
    $role = Db::name('auth_role')->where(['id'=>$data['id']])->find();
    $name = isset($role['name']) ? $role['name'] : '';
    $this->logAction('更新角色字段，ID:' . $data['id'] . '，角色名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);
    }

    public function delete($id)
    {
        if (!$this->hasPermission('role_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $role = Db::name('auth_role')->where('id', $id)->find();
        $name = isset($role['name']) ? $role['name'] : '';
        $res = Db::name('auth_role')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除角色设置，ID:' . $id . '，角色名称:' . $name);
        	return json(['status'=>'success','msg'=>'删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }


    public function del()
    {
        if (!$this->hasPermission('role_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $names = [];
        if (is_array($ids)) {
            $roles = Db::name('auth_role')->where('id', 'in', $ids)->column('name', 'id');
            foreach ($ids as $id) {
                $names[] = isset($roles[$id]) ? $roles[$id] : '';
            }
        } else {
            $role = Db::name('auth_role')->where('id', $ids)->find();
            $names[] = isset($role['name']) ? $role['name'] : '';
        }
        $del= Db::name('auth_role')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除角色设置，ID:' . json_encode($ids, JSON_UNESCAPED_UNICODE) . '，角色名称:' . json_encode($names, JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }
   
}
