<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class More extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index(Request $request)
    {
        // 获取当前页码并转换为整数
        $page = (int) $request->param('page', 1);
        // 每页显示的记录数并转换为整数
        $limit = (int) $request->param('limit', 10);

        $id=$request->param('id');
        // 获取表单数据
        $msg = Db::name('msg')->where('form_id', $id)->order('sign desc')->select()->toArray();

        $form=Db::name('form')->find($id);
       
        // 按照 sign 分组
        $groupedMsg = [];
        foreach ($msg as $item) {
            $groupedMsg[$item['sign']][] = $item;
        }

        // 获取总记录数
        $total = count($groupedMsg);
       
        // 分页处理
        $groupedMsg = array_slice($groupedMsg, ($page - 1) * $limit, $limit);

        View::assign([
            'groupedMsg' => $groupedMsg,
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
            'form'=>$form,
        ]);

        return View::fetch('index');
    }

    
    
   
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete()
    {
        $data=input('post.');
        $res = Db::name('msg')->where(['sign'=>$data['sign']])->delete();
        if($res){
            $this->logAction('清空留言，sign:' . $data['sign']);
        	return json(['status'=>'success','msg'=>'删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        $data=input('post.');
        $del = Db::name('msg')->where(['sign'=>$data['signs']])->delete();
        if($del){
            $this->logAction('批量清空留言，signs:' . json_encode($data['signs'], JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

    public function clearAll()
    {
    $data=input('post.');
    Db::name('msg')->where(['form_id'=>$data['form_id']])->delete();
    $this->logAction('全部清空留言，form_id:' . $data['form_id']);
    return json(['status' => 'success', 'msg' => '清空成功']);
    }
}
