<?php
declare (strict_types = 1);

namespace app\admin\controller;
use think\facade\View;
use think\facade\Db;
use think\facade\Cache;
use think\facade\App;
use think\Request;
use think\facade\Log;
use mysqli;


class Index extends Common
{

 
    public function menu()
    {
        $config = Db::name('config')->where('id', 1)->find();
        $model=Db::name('model')->where('status',1)->where('type',2)->field(['concat(ifnull(name,""),"内容") as title','concat("/admin/content/?id=",ifnull(id,"")) as href','concat("fa fa-file-text-o",ifnull("","")) as icon','concat("_self",ifnull("","")) as target'])->order('sort asc,id asc')->select();
        $single=Db::name('model')->where('status',1)->where('type',1)->field(['concat(ifnull(name,""),"内容") as title','concat("/admin/single/?id=",ifnull(id,"")) as href','concat("fa fa-file-text-o",ifnull("","")) as icon','concat("_self",ifnull("","")) as target'])->order('sort asc,id asc')->select();
        
        $result = $model->merge($single)->toArray();

        if($config['structure']=='2'){
            $result = array_slice($result, 0, 1);
            foreach($result as &$item) {
                $item['title'] = '内容列表';
            }
        }
        

        // 获取动态数据（除了留言表之外的其他表）
        $dynamicForms = Db::name('form')->where('id', '<>', '1')->order('id asc')->select();

        // 构建动态数据菜单项
        $dynamicMenuItems = [];
        foreach ($dynamicForms as $form) {
            $dynamicMenuItems[] = [
                'title' => $form['form_name'],
                'href' => '/admin/more/index/id/'. $form['id'],
                'icon' => 'fa fa-plus-square-o',
                'target' => '_self',
            ];
        }

        

    $menu = [
        
            'homeInfo'=>array
            (
                'title'=>"首页",
                'href'=>"/admin/index/welcome"
            ),
            'logoInfo'=>array
            (
                'title'=>"网站后台",
                'href'=>"",
                'image'=>"/public/static/admin/images/logo.png"
            ),
            'menuInfo'=>array
            (
                [
                    'title'=>'后台首页',
                    'href'=>'/admin/index/welcome',
                    'icon'=>'fa fa-home',
                    'target'=>'_self'
                ],
                [
                    'title'=>'全局设置',
                    'href'=>'',
                    'icon'=>'fa fa-globe',
                    'target'=>'_self',
                    'child'=>array
                    (
                        [
                            'title'=>'配置参数',
                            'href'=>'/admin/config',
                            'icon'=>'fa fa-sliders',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'定制标签',
                            'href'=>'/admin/label',
                            'icon'=>'fa fa-wrench',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'模型管理',
                            'href'=>'/admin/model',
                            'icon'=>'fa fa-codepen',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'栏目字段',
                            'href'=>'/admin/column',
                            'icon'=>'fa fa-external-link',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'html生成',
                            'href'=>'/admin/html',
                            'icon'=>'fa fa-file-code-o',
                            'target'=>'_self',
                        ],
                    )
                ],
                [
                    'title'=>'菜单管理',
                    'href'=>'/admin/category',
                    'icon'=>'fa fa-window-maximize',
                    'target'=>'_self'
                ],
                [
                    'title'=>'内容管理',
                    'href'=>'',
                    'icon'=>'fa fa-list-alt',
                    'target'=>'_self',
                    'child'=>$result,
                ],
                [
                    'title'=>'扩展内容',
                    'href'=>'',
                    'icon'=>'fa fa-arrows-alt',
                    'target'=>'_self',
                    'child' => array_merge([
                        [
                            'title' => '留言信息',
                            'href' => '/admin/msg',
                            'icon' => 'fa fa-question-circle-o',
                            'target' => '_self',
                        ],
                        [
                            'title' => '轮播图片',
                            'href' => '/admin/banner',
                            'icon' => 'fa fa-picture-o',
                            'target' => '_self',
                        ],
                        [
                            'title' => '友情链接',
                            'href' => '/admin/link',
                            'icon' => 'fa fa-link',
                            'target' => '_self',
                        ],
                        [
                            'title' => '自定义表单',
                            'href' => '/admin/form',
                            'icon' => 'fa fa-plus-square-o',
                            'target' => '_self',
                        ],
                    ], $dynamicMenuItems)
                ],
                [
                    'title'=>'会员模块',
                    'href'=>'',
                    'icon'=>'fa fa-user',
                    'target'=>'_self',
                    'child'=>array
                    (
                        [
                            'title'=>'会员列表',
                            'href'=>'/admin/user',
                            'icon'=>'fa fa-user-o',
                            'target'=>'_self',
                        ],
                    )
                ],
                [
                    'title'=>'权限管理',
                    'href'=>'',
                    'icon'=>'fa fa-shield',
                    'target'=>'_self',
                    'child'=>array
                    (
                        [
                            'title'=>'角色设置',
                            'href'=>'/admin/role',
                            'icon'=>'fa fa-sitemap',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'用户列表',
                            'href'=>'/admin/authuser',
                            'icon'=>'fa fa-user-circle',
                            'target'=>'_self',
                        ],
                    )
                ],
                [
                    'title'=>'系统设置',
                    'href'=>'',
                    'icon'=>'fa fa-gears',
                    'target'=>'_self',
                    'child'=>array
                    (
                        [
                            'title'=>'站点信息',
                            'href'=>'/admin/system',
                            'icon'=>'fa fa-cog',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'公司信息',
                            'href'=>'/admin/company',
                            'icon'=>'fa fa-copyright',
                            'target'=>'_self',
                        ],
                        [
                            'title'=>'系统日志',
                            'href'=>'/admin/log',
                            'icon'=>'fa fa-bug',
                            'target'=>'_self',
                        ],
                    )
                ],
            ),
        ];
       

        // 递归过滤菜单项，保留有xxx_view权限的项，超级管理员全部显示
        $permissions = $this->userPermissions;
        $isSuper = in_array('*', $permissions);
        $permMap = [
            '配置参数' => 'config_view',
            '定制标签' => 'label_view',
            '模型管理' => 'model_view',
            '栏目字段' => 'column_view',
            'html生成' => 'html_view',
            '菜单管理' => 'category_view',
            '内容管理' => 'content_view',
            '留言信息' => 'msg_view',
            '轮播图片' => 'banner_view',
            '友情链接' => 'link_view',
            '自定义表单' => 'form_view',
            '会员列表' => 'user_view',
            '角色设置' => 'role_view',
            '用户列表' => 'authuser_view',
            '站点信息' => 'system_view',
            '公司信息' => 'company_view',
            '系统日志' => 'log_view',
        ];
        $filterMenu = function($arr) use (&$filterMenu, $permMap, $permissions, $isSuper) {
            $out = [];
            foreach ($arr as $item) {
                $perm = isset($permMap[$item['title']]) ? $permMap[$item['title']] : null;
                $has = $isSuper || !$perm || in_array($perm, $permissions);
                if ($has) {
                    if (isset($item['child']) && is_array($item['child'])) {
                        $item['child'] = $filterMenu($item['child']);
                        if (empty($item['child']) && $perm) continue;
                    }
                    $out[] = $item;
                }
            }
            return $out;
        };
        //左侧菜单栏无权限隐藏
        // $menu['menuInfo'] = $filterMenu($menu['menuInfo']);
        $json=json($menu);
        return $json;
    }

    public function page()
    {
        $model=Db::name('model')->where('status',1)->where('type',2)->field(['concat(ifnull(name,""),"内容") as title','concat("/admin/content/?id=",ifnull(id,"")) as href','concat("fa fa-file-text-o",ifnull("","")) as icon','concat("_self",ifnull("","")) as target'])->order('sort asc,id asc')->select();
        
        return $model;
    }

    public function version()
    {
        // 仅超级管理员可操作
        $adminId = session('admin_id');
        if ($adminId != 1) {
            return json('无权限检测');
        }
        
        // 获取前端传递的参数
        $version = input('post.version');
        $domain = input('post.domain');

        // 远程请求的 URL
        $url = 'https://lgcms.com/index/index/version';

        // 初始化 cURL
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, [
            'version' => $version,
            'domain' => $domain,
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 如果是 HTTPS 请求，关闭 SSL 验证
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 如果是 HTTPS 请求，关闭 SSL 验证
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');

        // 执行请求
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);

        // 检查请求是否成功
        if ($httpCode !== 200) {
            return json(['status' => 0, 'msg' => '请求失败: ' . $error]);
        }

        // 确保返回的是 JSON 格式
        $decodedResponse = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return json(['status' => 0, 'msg' => '响应解析失败: ' . json_last_error_msg()]);
        }
        $this->logAction('检查系统更新，当前版本：' . $version);
        return json($decodedResponse); // Always return JSON response
    }

    /**
     * 更新系统
     * @return \think\response\Json
     */

     public function updateFromRemote()
     {
         Cache::set('update_progress', 0); // 升级开始
     
         $remoteUrl = 'https://lgcms.com/index/index/download';
         $savePath = root_path() . 'app.zip';
         $extractTo = root_path();

         $version = input('post.version');
     
         // 下载
         $ch = curl_init($remoteUrl);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
         curl_setopt($ch, CURLOPT_TIMEOUT, 300); // 适当加大超时时间
         curl_setopt($ch, CURLOPT_POST, 1);
         curl_setopt($ch, CURLOPT_POSTFIELDS, [
             'domain' => $_SERVER['HTTP_HOST'],
             'version'=> $version,
         ]);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
         curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
         curl_setopt($ch, CURLOPT_REFERER, 'https://lgcms.com/');
     
         $data = curl_exec($ch);
         $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
         $error = curl_error($ch);
         curl_close($ch);
     
         if ($data === false || $httpCode != 200) {
             Cache::set('update_progress', 0);
             return json([
                 'status' => 0,
                 'msg' => '远程下载失败: ' . $error . ' | HTTP_CODE: ' . $httpCode
             ]);
         }
     
         if (!is_dir(dirname($savePath))) {
             mkdir(dirname($savePath), 0777, true);
         }
     
         $result = file_put_contents($savePath, $data);
         if ($result === false) {
             Cache::set('update_progress', 0);
             return json(['status' => 0, 'msg' => '保存文件失败']);
         }
     
         // 解压
        $zip = new \ZipArchive();
        if ($zip->open($savePath) === TRUE) {
            
            // 解压成功后
            $zip->extractTo($extractTo);
            $zip->close();

            unlink($savePath); // 删除压缩包

            // 直接检查根目录是否有 update.sql
            $updateFilePath = $extractTo . '/update.sql'; // 检查的文件路径
            
            if (file_exists($updateFilePath)) {
                // 导入update.sql（覆盖更新）
                $importResult = $this->importUpdateSql($updateFilePath);
                if ($importResult['status']) {
                    Cache::set('update_progress', 100);
                    return json(['status' => 1, 'msg' => '恭喜你，更新完成！']);
                } else {
                    Cache::set('update_progress', 0);
                    return json(['status' => 0, 'msg' => '更新完成但数据库导入失败：'.$importResult['msg']]);
                }
            } else {
                // 未找到 update.sql 文件
                Cache::set('update_progress', 100); // 升级完成
                return json(['status' => 1, 'msg' => '恭喜你，更新完成！']);
            }
            
         } else {
             Cache::set('update_progress', 0);
             return json(['status' => 0, 'msg' => '解压失败！']);
         }
     }

     /**
     * 导入 update.sql 文件并执行
     * 
     * @param string $updateSqlPath update.sql 文件路径
     * @return void
     */

    protected function importUpdateSql($updateFilePath)
    {
        
        try {
           
            $sql = file_get_contents($updateFilePath);

            $dbConfig = config('database.connections.mysql');
            $servername = $dbConfig['hostname'];
            $username = $dbConfig['username'];
            $password = $dbConfig['password'];
            $dbname   = $dbConfig['database'];
            $hostport = $dbConfig['hostport'];

            // 创建数据库连接
            try {
                $db = new mysqli($servername, $username, $password);
                
                // 创建数据库
                $createDbQuery = "CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8 COLLATE utf8_unicode_ci";
               

                // 选择数据库
                $db->select_db($dbname);
            } catch (\Exception $e) {
               
            }
            
            // 导入数据库文件
            try {
                $sql = file_get_contents($updateFilePath);
               
                // 自动为每个 CREATE TABLE 加上 TRUNCATE TABLE（如果表已存在）
                $sql = preg_replace_callback(
                    '/CREATE\s+TABLE\s+`?([a-zA-Z0-9_]+)`?/i',
                    function ($matches) {
                        // 在每个 CREATE TABLE 前加上 TRUNCATE TABLE 语句，清空表数据
                        return "DROP TABLE IF EXISTS `{$matches[1]}`;\nCREATE TABLE `{$matches[1]}`";
                    },
                    $sql
                );

                $db->multi_query($sql);
                // 确保执行所有语句
                do {
                    if ($result = $db->store_result()) {
                        $result->free();
                    }
                } while ($db->more_results() && $db->next_result());

            }catch (\Exception $e) {
                return ['status' => 0, 'msg' => 'SQL 文件导入失败：'.$e->getMessage()];
            }

            // 删除 SQL 文件
            unlink($updateFilePath);
            return ['status' => 1, 'msg' => 'SQL 文件导入成功'];
        } catch (\Exception $e) {
            return ['status' => 0, 'msg' => $e->getMessage()];
        }
    }
   
    public function getUpdateProgress()
    {
        $percent = Cache::get('update_progress', 0);
        return json(['percent' => intval($percent)]);
    }

    public function images()
    {
        return View::fetch('images');
    }

    public function imageslist()
    {
        return View::fetch('imageslist');
    }
    
    public function directory_images()
    {
        return View::fetch('directory_images');
    }
    

    public function clear()
    {
        // 仅超级管理员可操作
        $adminId = session('admin_id');
        if ($adminId != 1) {
            return json(['msg'=>'无权限清除访客','status'=>'fail']);
        }
        $count=Db::name('count')->delete(true);
        if($count){
            $this->logAction('清除所有访客记录');
            return json(['msg'=>'清除成功','status'=>'success']);
        }else{
            return json(['msg'=>'清除失败','status'=>'fail']);
        }
    }

    public function clearCache()
    {
        // 清除所有缓存
        Cache::clear();

        // 手动删除缓存目录中的文件，排除 session 文件夹
        $runtimePath = root_path() . 'runtime' . DIRECTORY_SEPARATOR;
        $this->deleteFiles($runtimePath, ['session']);

        // 清缓存后立即尝试重建 sitemap（不中断主流程）
        $sitemapStatus = false;
        try {
            $sitemapDir = $runtimePath . 'sitemap' . DIRECTORY_SEPARATOR;
            if (!is_dir($sitemapDir)) { @mkdir($sitemapDir, 0777, true); }
            $sitemapStatus = (new \app\home\controller\Sitemap())->rebuildImmediately();
        } catch (\Throwable $e) {
            $sitemapStatus = false;
        }

        // 返回成功消息
        return json([
            'code' => '1',
            'msg'  => '清理缓存完成',
            'sitemap' => $sitemapStatus ? '生成成功' : '生成失败(查看 runtime/sitemap/rebuild.log)'
        ]);
        
    }

    private function deleteFiles($path, $excludeDirs = [])
    {
        if (is_dir($path)) {
            $files = scandir($path);
            foreach ($files as $file) {
                if ($file != '.' && $file != '..') {
                    $fullPath = $path . DIRECTORY_SEPARATOR . $file;
                    if (is_dir($fullPath)) {
                        if (!in_array($file, $excludeDirs)) {
                            $this->deleteFiles($fullPath, $excludeDirs);
                            rmdir($fullPath);
                        }
                    } else {
                        unlink($fullPath);
                    }
                }
            }
        }
    }

    public function index()
    {
        
        return View::fetch();
    }

    // 获取报表数据
    public function getChartData()
    {
        // 获取最近30天的日期
        $dates = [];
        for ($i = 29; $i >= 0; $i--) {
            $dates[] = date('m-d', strtotime("-{$i} days"));
        }

        // 获取所有来源类型
        $allTypes = Db::name('count')->distinct(true)->column('referer_type');

        // 构造每种来源类型每天的访问量
        $series = [];
        foreach ($allTypes as $type) {
            $data = [];
            foreach ($dates as $date) {
                $startOfDay = date('Y') . '-' . $date . ' 00:00:00';
                $endOfDay = date('Y') . '-' . $date . ' 23:59:59';
                $count = Db::name('count')
                    ->where('referer_type', $type)
                    ->whereBetweenTime('time', $startOfDay, $endOfDay)
                    ->count();
                $data[] = $count;
            }
            $series[] = [
                'name' => $type,
                'type' => 'line',
                'data' => $data
            ];
        }

        // 获取设备访问统计数据（原有代码）
        $deviceStats = Db::name('count')
            ->field('device_type, COUNT(*) as count')
            ->group('device_type')
            ->select()
            ->toArray();

        $formattedDeviceStats = [];
        foreach ($deviceStats as $stat) {
            $formattedDeviceStats[] = [
                'value' => $stat['count'],
                'name' => $stat['device_type']
            ];
        }

        return json([
            'status' => 'success',
            'data' => [
                'dates' => $dates,
                'refererTypes' => $allTypes,
                'series' => $series,
                'deviceStats' => $formattedDeviceStats
            ]
        ]);
    }


    function get_count(Request $request)
    {
        $limit = $request->param('limit')?$request->param('limit'):5;
        $table = Db::name('count')->order('id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }
    

    public function welcome()
    {

        $count = Db::name('count')->count();
        $count_day = Db::name('count')->whereBetweenTime('time', date('Y-m-d 00:00:00'), date('Y-m-d 23:59:59'))->count();

        // 获取表单数据
        $msg = Db::name('msg')->where('form_id', 1)->order('sign desc')->select()->toArray();

        // 按照 sign 分组
        $groupedMsg = [];
        foreach ($msg as $item) {
            $groupedMsg[$item['sign']][] = $item;
        }

        // 获取总记录数
        $msg = count($groupedMsg);

        $banner=Db::name('banner')->count();
        $link=Db::name('link')->count();
        $thinkphp=App::version();
        View::assign([
            'sys_info'=>$this->get_sys_info(),
            'msg'=>$msg,
            'banner'=>$banner,
            'link'=>$link,
            'count'=>$count,
            'count_day'=>$count_day,
            'thinkphp'=>$thinkphp,
        ]);
        return View::fetch();
    }

    public function user_password()
    {
        if($data=input('post.')){
            $admin=Db::name('admin')->where(['id'=>$data['id']])->find();
            if(md5($data['old_password'])!==$admin['password']){
                return json(['status'=>'fail','msg'=>"旧密码不正确！"]);
               
            }
            $password=Db::name('admin')->where(['id'=>$data['id']])->update(['password'=>md5($data['new_password'])]);
            if($password){
                session(null);
                return json(['status'=>'success','msg'=>"修改密码成功，请重新登录！"]);
            }else{
                return json(['status'=>'fail','msg'=>"修改密码错误！"]);
            }
        }
        return View::fetch();
    }
    
    public function user_setting()
    {
        if($data=input('post.')){
            $admin=Db::name('admin')->where(['id'=>$data['id']])->save($data);
            if($admin){
                return json(['status'=>'success','msg'=>'更新成功']);
            }else{
                return json(['status'=>'fail','msg'=>'更新失败']);
            }
        }
        $adname =session('adname');
        $setting=Db::name('admin')->where(['id'=>$adname['id']])->find();
        View::assign([
            'setting'=>$setting,
        ]);
        return View::fetch();
    }

    public function get_sys_info()
    {
        $sys_info['os']             = PHP_OS;
        $sys_info['zlib']           = function_exists('gzclose') ? 'YES' : '<font color="red">NO（请开启 php.ini 中的php-zlib扩展）</font>';//zlib
        $sys_info['safe_mode']      = (boolean) ini_get('safe_mode') ? 'YES' : 'NO';//safe_mode = Off       
        $sys_info['timezone']       = function_exists("date_default_timezone_get") ? date_default_timezone_get() : "no_timezone";
        $sys_info['curl']           = function_exists('curl_init') ? 'YES' : '<font color="red">NO（请开启 php.ini 中的php-curl扩展）</font>';  
        $web_server                 = $_SERVER['SERVER_SOFTWARE'];
        if (stristr($web_server, 'apache')) {
            $web_server = 'apache';
        } else if (stristr($web_server, 'nginx')) {
            $web_server = 'nginx';
        } else if (stristr($web_server, 'iis')) {
            $web_server = 'iis';
        }
        $sys_info['web_server']     = $web_server;
        $sys_info['phpv']           = phpversion();
        $sys_info['postsize']       = @ini_get('file_uploads') ? ini_get('post_max_size') :'未知';
        $sys_info['fileupload']     = @ini_get('file_uploads') ? ini_get('upload_max_filesize') :'未开启';
        $sys_info['max_ex_time']    = @ini_get("max_execution_time").'s'; //脚本最大执行时间
        $sys_info['set_time_limit'] = function_exists("set_time_limit") ? true : false;
        $sys_info['domain']         = $_SERVER['HTTP_HOST'];
       
        $sys_info['memory_limit']   = ini_get('memory_limit');
        $mysqlinfo = Db::query("SELECT VERSION() as version");
        $sys_info['mysql_version']  = $mysqlinfo[0]['version'];
        if(function_exists("gd_info")){
            $gd = gd_info();
            $sys_info['gdinfo']     = $gd['GD Version'];
        }else {
            $sys_info['gdinfo']     = "未知";
        }
        if (extension_loaded('zip')) {
            $sys_info['zip']     = "YES";
        } else {
            $sys_info['zip']     = '<font color="red">NO（请开启 php.ini 中的php-zip扩展）</font>';
        }

        return $sys_info;
    }

}
