<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Form extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        if (!$this->hasPermission('form_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

    public function create()
    {
        if (!$this->hasPermission('form_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加权限！</div>';
        }
        $gid=Db::name('banner')->distinct(true)->field('gid')->order('gid asc')->select();
        View::assign([
            'gid'=>$gid
        ]);
        return View::fetch('add');
    }

    public function getform(Request $request)
    {
        if (!$this->hasPermission('form_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('form')?$request->param('limit'):10;
        $table = Db::name('form')->order('id asc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        if (!$this->hasPermission('form_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加']);
        }
        $data=input('post.');
        $data['time']=time();
        $ext='ay_';
        $data['table_name']=$ext.$data['table_name'];
        $formId = Db::name('form')->strict(false)->insertGetId($data);
        if($formId){
            $formName = isset($data['form_name']) ? $data['form_name'] : '';
            $this->logAction('添加自定义表单，ID:' . json_encode($formId, JSON_UNESCAPED_UNICODE) . '，表单名称:' . json_encode($formName, JSON_UNESCAPED_UNICODE));
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

   

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        if (!$this->hasPermission('form_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑权限！</div>';
        }
        $edit=Db::name('form')->find($id);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        if (!$this->hasPermission('form_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $id = $data['id'];
        // 获取数据库中的原始数据
        $originalData = Db::name('form')->where('id', $id)->find();
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }
        $form=Db::name('form')->where(['id'=>$data['id']])->strict(false)->save($data);
        if($form){
            $formName = isset($data['form_name']) ? $data['form_name'] : '';
            $this->logAction('更新自定义表单，ID:' . json_encode($data['id'], JSON_UNESCAPED_UNICODE) . '，表单名称:' . json_encode($formName, JSON_UNESCAPED_UNICODE));
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }


    public function click()
    {
        if (!$this->hasPermission('form_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $data=input('post.');
        $click=Db::name('form')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        if($click){
            return json(['msg'=>'编辑成功','status'=>'success']);
        }else{
            return json(['msg'=>'编辑失败','status'=>'fail']);
        }
    }

   
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        if (!$this->hasPermission('form_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除']);
        }
        $form = Db::name('form')->where('id', $id)->find();
        $formName = isset($form['form_name']) ? $form['form_name'] : '';
        $res = Db::name('form')->where('id',$id)->delete();
        if($res){
            Db::name('fcode')->where('form_id',$id)->delete();
            $this->logAction('删除自定义表单，ID:' . $id . '，表单名称:' . $formName);
        	return json(['status'=>'success','msg'=>'删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        if (!$this->hasPermission('form_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除']);
        }
        $data=input('post.');
        $ids = $data['id'];
        $formNames = [];
        if (is_array($ids)) {
            $forms = Db::name('form')->where('id', 'in', $ids)->column('form_name', 'id');
            foreach ($ids as $id) {
                $formNames[] = isset($forms[$id]) ? $forms[$id] : '';
            }
        } else {
            $form = Db::name('form')->where('id', $ids)->find();
            $formNames[] = isset($form['form_name']) ? $form['form_name'] : '';
        }
        $del= Db::name('form')->where(['id'=>$ids])->delete();
        if($del){
            Db::name('fcode')->where(['form_id'=>$ids])->delete();
            $this->logAction('批量删除自定义表单，ID:' . json_encode($ids, JSON_UNESCAPED_UNICODE) . '，表单名称:' . json_encode($formNames, JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
