<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Fcode extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        $id=input('fcode');
        View::assign([
            'fcode'=>$id,
        ]);
        return View::fetch('index');
    }


    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */

   

    public function create()
    {
        $fcode=input('fcode');
        View::assign([
            'fcode'=>$fcode
        ]);
        return View::fetch('add');
    }

    public function getfcode(Request $request)
    {
        $limit = $request->param('fcode')?$request->param('limit'):10;
        $table = Db::name('fcode')->order('sorting asc,id asc')->where(['form_id'=>$_GET['fcode']])->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        $data=input('post.');
        $data['form_id']=$data['fcode'];
        $fcodeId = Db::name('fcode')->strict(false)->insertGetId($data);
        if($fcodeId){
            $name = isset($data['name']) ? $data['name'] : '';
            $this->logAction('添加表单字段，ID:' . $fcodeId . '，表名称:' . $name);
            return json(['msg'=>'添加成功','status'=>'success']);
        }else{
            return json(['msg'=>'添加失败','status'=>'fail']);
        }
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        $edit=Db::name('fcode')->find($id);
        View::assign([
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        $data=input('post.');
        $id = $data['id'];
        // 获取数据库中的原始数据
        $originalData = Db::name('fcode')->where('id', $id)->find();
     
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }


        $form=Db::name('fcode')->where(['id'=>$data['id']])->strict(false)->save($data);
        if($form){
            $name = isset($data['name']) ? $data['name'] : '';
            $this->logAction('编辑表单字段，ID:' . $data['id'] . '，表名称:' . $name);
            return json(['status'=>'success','msg'=>'更新成功']);
        }else{
            return json(['status'=>'fail','msg'=>'更新失败']);
        }
    }

    public function required(Request $request)
    {
		$id = $request->param('id');
		$required = $request->param('required');
		if($required){
			Db::name('fcode')->where('id',$id)->update(['required'=>0]);
		}else{
			Db::name('fcode')->where('id',$id)->update(['required'=>1]);
		}
	}


    public function click()
    {
        $data=input('post.');
        $click=Db::name('fcode')->where(['id'=>$data['id']])->update([$data['field']=>$data['value']]);
        $fcode = Db::name('fcode')->where(['id'=>$data['id']])->find();
        $name = isset($fcode['name']) ? $fcode['name'] : '';
        if($click){
            $this->logAction('修改表单字段，ID:' . $data['id'] . '，表名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);
            return json(['msg'=>'编辑成功','status'=>'success']);
        }else{
            return json(['msg'=>'编辑失败','status'=>'fail']);
        }
    }

   
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        $fcode = Db::name('fcode')->where('id', $id)->find();
        $name = isset($fcode['name']) ? $fcode['name'] : '';
        $res = Db::name('fcode')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除表单字段，ID:' . $id . '，表名称:' . $name);
        	return json(['status'=>'success','msg'=>'删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        $data=input('post.');
        $ids = $data['id'];
        $names = [];
        if (is_array($ids)) {
            $fcodes = Db::name('fcode')->where('id', 'in', $ids)->column('name', 'id');
            foreach ($ids as $id) {
                $names[] = isset($fcodes[$id]) ? $fcodes[$id] : '';
            }
        } else {
            $fcode = Db::name('fcode')->where('id', $ids)->find();
            $names[] = isset($fcode['name']) ? $fcode['name'] : '';
        }
        $del= Db::name('fcode')->where(['id'=>$ids])->delete();
        if($del){
            $this->logAction('批量删除表单字段，ID:' . json_encode($ids, JSON_UNESCAPED_UNICODE) . '，表名称:' . json_encode($names, JSON_UNESCAPED_UNICODE));
        	return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
        	return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
