<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Company extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        // 权限：查看
        if (!$this->hasPermission('company_view')) {
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问权限！</div>';
        }
        if($data=input('post.')){
            // 权限：编辑
            if (!$this->hasPermission('company_edit')) {
                return json(['status'=>'fail','msg'=>'无权限编辑']);
            }
            // 获取数据库中的原始数据
            $originalData = Db::name('system')->where('id',1)->find();
            // 只记录有变动的字段
            $logArr = [];
            $hasChanges = false;
            foreach ($data as $key => $value) {
                $old = isset($originalData[$key]) ? $originalData[$key] : '';
                $old = is_null($old) ? '' : $old;
                $new = is_null($value) ? '' : $value;
                if ($old != $new) {
                    $hasChanges = true;
                    $logArr[] = ['字段'=>$key, '原'=>$old, '改为'=>$new];
                }
            }
            if (!$hasChanges) {
                return json(['status' => 'fail', 'msg' => '没有做任何更新']);
            }
            $system=Db::name('system')->where('id',1)->strict(false)->save($data);
            if($system){
                if (!empty($logArr)) {
                    $this->logAction('更新公司信息:' . json_encode($logArr, JSON_UNESCAPED_UNICODE));
                }
                return json(['msg'=>'更新成功','status'=>'success']);
            }else{
                return json(['msg'=>'更新失败','status'=>'fail']);
            }
        }
        $system=Db::name('system')->where('id',1)->find();
        View::assign([
            'system'=>$system,
        ]);
        return View::fetch('index');
    }

    
}
