<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;

class Column extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        // 权限拦截：查看权限
        if (!$this->hasPermission('column_view')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限查看栏目字段']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问栏目字段权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */


    public function create()
    {
        // 权限拦截：添加权限
        if (!$this->hasPermission('column_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加栏目字段']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加栏目字段权限！</div>';
        }
        $model=input('model');
        // 获取所有分类并生成树形结构
        $lst=Db::name('category')->order('id asc')->select();
        $lst=tree($lst);

        View::assign([
            'lst' => $lst,
            'model'=>$model,
        ]);
        return View::fetch('add');
    }

    public function getcolumn(Request $request)
    {
        // 权限拦截：查看权限
        if (!$this->hasPermission('column_view')) {
            return json(['code'=>0, 'count'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $limit = $request->param('limit')?$request->param('limit'):15;
        $builder = Db::name('column');
        $table =$builder->order('sort asc,id desc')->paginate(['list_rows'=>$limit])->toArray();
        return json(['code'=>0, 'count'=>$table['total'], 'data'=>$table['data']]);
    }


    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        // 权限拦截：添加权限
        if (!$this->hasPermission('column_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加栏目字段']);
        }
        $data=input('post.');
        
        if($data['field'] && ! preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['field'])) {
            return json(['msg'=>'字段名称只允许字母、数字、横线、斜线组成！','status'=>'fail']);
        }else{
         
           
            $ext='ext_';
            $data['field']=$ext.$data['field'];
            $data['appoint'] = implode(',', $data['appoint']);
            //如果appoint是0,则说明勾选的改模型所有的指定的栏目
            if($data['appoint']=='0'){
                $data['appoint']='';
                $category=Db::name('category')->select();
                foreach($category as $k=>$v){
                    $data['appoint'].=','.$v['id'];
                }
                //去除第一个逗号
                $data['appoint']=trim($data['appoint'],',');
            }else{
                // 如果 appoint 不等于 '0'，检查是否包含 0 并去掉
                $appointArray = explode(',', $data['appoint']); // 转换为数组
                $appointArray = array_filter($appointArray, function ($value) {
                    return $value !== '0'; // 过滤掉 0
                });
                $data['appoint'] = implode(',', $appointArray); // 转换回字符串
            }
            
            $category=Db::name('category')->select();
            foreach($category as $k=>$v){
                $appointArr = array_filter(explode(',', $data['appoint']));
                if (in_array($v['id'], $appointArr)) {
                    Db::name('category_ext')->insert(['category'=>$v['id'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                }
            }
          

            $column=Db::name('column')->where(['field'=>$data['field']])->find();
            if($column){
                return json(['msg'=>'字段名称已经存在，不能重复添加！','status'=>'fail']);
            }else{
                Db::name('column')->insert($data);
                $id = Db::name('column')->getLastInsID();
                $name = $data['field'];
                $this->logAction('添加栏目字段，ID:' . $id . '，字段名称:' . $name);
                return json(['msg'=>'添加成功','status'=>'success']);
            }
        }
        
    }

    /**
     * 显示指定的资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function read($id)
    {
        //
    }

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        // 获取所有分类并生成树形结构
        
        // 权限拦截：编辑权限
        if (!$this->hasPermission('column_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑栏目字段']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑栏目字段权限！</div>';
        }
        $edit=Db::name('column')->find($id);
        $edit['field']=substr($edit['field'],4); // 去除前缀ext_//前四位字符
        $lst=Db::name('category')->order('id asc')->select();
        $lst=tree($lst);
        $appointArray = explode(',', $edit['appoint']);
        foreach ($lst as &$item) {
            if (in_array($item['id'], $appointArray)) {
                $item['selected'] = true; // 增加 selected 标记
            } else {
                $item['selected'] = false; // 未选中
            }
        }
        View::assign([
            'lst' => $lst,
            'edit'=>$edit,
        ]);
        return View::fetch('edit');
    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('column_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑栏目字段']);
        }
        $data=input('post.');
        $id=$data['id'];

        $ext='ext_';
        $data['field']=$ext.$data['field'];
        

        // 获取数据库中的原始数据
        $originalData = Db::name('column')->where('id', $id)->find();
        $data['appoint'] = implode(',', $data['appoint']);
        //如果appoint是0,则说明勾选的改模型所有的指定的栏目
        if($data['appoint']=='0'){
            $data['appoint']='';
            $category=Db::name('category')->select();
            foreach($category as $k=>$v){
                $data['appoint'].=','.$v['id'];
            }
            //去除第一个逗号
            $data['appoint']=trim($data['appoint'],',');
        }else{
            // 如果 appoint 不等于 '0'，检查是否包含 0 并去掉
            $appointArray = explode(',', $data['appoint']); // 转换为数组
            $appointArray = array_filter($appointArray, function ($value) {
                return $value !== '0'; // 过滤掉 0
            });
            $data['appoint'] = implode(',', $appointArray); // 转换回字符串
        }

     
        //比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            if (isset($originalData[$key]) && $originalData[$key] != $value) {
                $hasChanges = true;
                break;
            }
        }
        
        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '没有做任何修改']);
        }

        if($data['field'] && ! preg_match('/^[a-zA-Z0-9\-_\/]+$/', $data['field'])) {
            return json(['msg'=>'字段名称只允许字母、数字、横线、斜线组成！','status'=>'fail']);
        }else{
            //原先字段情况
            $column=Db::name('column')->where(['field'=>$data['field']])->find();
            
            $save=Db::name('column')->where(['id'=>$data['id']])->save($data);
            $name = $data['field'];
            if($save){
                $this->logAction('更新栏目字段，ID:' . $data['id'] . '，字段名称:' . $name);
                //如果修改了 指定栏目的情况
                if($column['appoint']!==$data['appoint']){
                    // 1. 转为数组
                    $newAppointArr = array_filter(explode(',', $data['appoint']));      // 新的栏目id数组
                    $oldAppointArr = array_filter(explode(',', $column['appoint']));  // 旧的栏目id数组

                    // 2. 计算新增和减少的栏目id
                    $addArr = array_diff($newAppointArr, $oldAppointArr);   // 需要新增的栏目id
                    $delArr = array_diff($oldAppointArr, $newAppointArr);   // 需要删除的栏目id

                    // 3. 新增：为新增栏目下所有内容添加自定义字段
                    if (!empty($addArr)) {
                        //列表页扩展字段
                        $category = Db::name('category')->where([['id', 'in', $addArr]])->select()->toArray();
                        foreach ($category as $v) {
                            Db::name('category_ext')->insert(['category'=>$v['id'],'description'=>$data['description'],'type'=>$data['type'],'field'=>$data['field'],'sort'=>$data['sort']]);
                            
                        }
                    }
                    // 4. 删除：为减少栏目下所有内容删除自定义字段
                    if (!empty($delArr)) {
                        //列表页扩展字段
                        $category = Db::name('category')->where([['id','in',$delArr]])->select()->toArray();
                        foreach ($category as $v) {
                            Db::name('category_ext')->where(['category'=>$v['id'],'field'=>$data['field']])->delete();
                        }
                    }
                    return json(['status'=>'success','msg'=>'更新成功']);
                }else{
                    Db::name('category_ext')->where(['field'=>$data['field']])->update(['description'=>$data['description'],'type'=>$data['type'],'sort'=>$data['sort']]);
                    return json(['status'=>'success','msg'=>'更新成功']);
                }
              
            }else{
                return json(['status'=>'fail','msg'=>'更新失败']);
            }
          

        
        }
    }


    public function click()
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('column_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑栏目字段']);
        }
        $data=input('post.');
        $column=Db::name('column')->where(['id'=>$data['id']])->find();
        $click=Db::name('column')->where(['id'=>$column['id']])->update([$data['field']=>$data['value']]);
        $name = $column['field'];
        $this->logAction('修改栏目字段，ID:' . $column['id'] . '，字段名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);
        Db::name('category_ext')->where(['field'=>$column['field']])->update(['sort'=>$data['value']]);
    }
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        //删除栏目扩展字段
        // 权限拦截：删除权限
        if (!$this->hasPermission('column_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除栏目字段']);
        }
        $column=Db::name('column')->find($id);
        $name = $column['field'];
        Db::name('category_ext')->where(['field'=>$column['field']])->delete();
        $res = Db::name('column')->where('id',$id)->delete();
        if($res){
            $this->logAction('删除栏目字段，ID:' . $id . '，字段名称:' . $name);
            return json(['status'=>'success','msg'=>'删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'删除失败']);
        }
    }
    
    public function del()
    {
        // 权限拦截：批量删除权限
        if (!$this->hasPermission('column_delete')) {
            return json(['status'=>'fail','msg'=>'无权限批量删除栏目字段']);
        }
        $data=input('post.');
        $ids=$data['id'];
        $names = [];
        if (is_array($ids)) {
            $fields = Db::name('column')->where('id', 'in', $ids)->column('field', 'id');
            foreach ($ids as $id) {
                $names[] = isset($fields[$id]) ? $fields[$id] : '';
            }
        } else {
            $column = Db::name('column')->where('id', $ids)->find();
            $names[] = isset($column['field']) ? $column['field'] : '';
        }
        foreach($ids as $k=>$v){
            $column=Db::name('column')->where('id',$v)->find();
            $category=Db::name('category_ext')->where(['field'=>$column['field']])->find();
            if($category){
                Db::name('category_ext')->where(['field'=>$column['field']])->delete();
            }
        }
        $del= Db::name('column')->where(['id'=>$data['id']])->delete();
        if($del){
            $this->logAction('批量删除栏目字段，ID:' . json_encode($ids) . '，字段名称:' . json_encode($names, JSON_UNESCAPED_UNICODE));
            return json(['status'=>'success','msg'=>'批量删除成功']);
        }else{
            return json(['status'=>'fail','msg'=>'批量删除失败']);
        }
    }

}
