<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\Request;
use think\facade\View;
use think\facade\Db;
use think\facade\Filesystem;
use think\facade\Session;

class Category extends Common
{
    /**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
        // 权限拦截：查看权限
        if (!$this->hasPermission('category_view')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限查看栏目']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无访问栏目管理权限！</div>';
        }
        return View::fetch('index');
    }

    /**
     * 显示创建资源表单页.
     *
     * @return \think\Response
     */
    public function create()
    {
        // 权限拦截：添加权限
        if (!$this->hasPermission('category_add')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限添加栏目']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无添加栏目权限！</div>';
        }
        
        $lst=Db::name('category')->order('id asc')->select();
        $lst=tree($lst);
        $model = Db::name('model')->where('status', 1)->order('sort asc, id asc')->select()->toArray();
        $modelDetails = array_column($model, 'details');
        $templateDir = './template/index';
        $allFiles = scandir($templateDir);
        $templateFiles = array_diff($allFiles, $modelDetails);
        $template = array_filter($templateFiles, function($file) {
            return substr($file, -5) === '.html';
        });
        View::assign([
            'lst' => json_encode($lst, JSON_UNESCAPED_UNICODE),
            'model'=>$model,
            'template'=>$template,
        ]);
        return View::fetch('add');
    }


    public function getcategory(Request $request)
    {
        // 权限拦截：查看权限
        if (!$this->hasPermission('category_view')) {
            return json(['code'=>0, 'data'=>[], 'msg'=>'无权限']);
        }
        $categories = Db::name('category')->order('sort asc, id asc')->select();
        return json(['code' => 0, 'data' => $categories]);
    }
    

   

    public function status(Request $request)
    {
        if (!$this->hasPermission('category_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $status = $request->param('status');
        $cat = Db::name('category')->find($id);
        $name = isset($cat['name']) ? $cat['name'] : '';
        $res = Db::name('category')->where('id', $id)->update(['status' => $status]);
        if($res !== false){
            $statusText = $status == 1 ? '显示' : '隐藏';
            $this->logAction('设置栏目状态，ID:' . $id . '，栏目名称:' . $name . '，状态:' . $statusText);
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}


    public function isrecommend(Request $request)
    {
        if (!$this->hasPermission('category_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑']);
        }
        $id = $request->param('id');
        $isrecommend = $request->param('isrecommend');
        $cat = Db::name('category')->find($id);
        $name = isset($cat['name']) ? $cat['name'] : '';
        $res = Db::name('category')->where('id', $id)->update(['isrecommend' => $isrecommend]);
        if($res !== false){
            $recText = $isrecommend == 1 ? '推荐' : '不推荐';
            $this->logAction('设置栏目推荐状态，ID:' . $id . '，栏目名称:' . $name . '，状态:' . $recText);
            return json(['status' => 'success', 'msg' => '状态已更新']);
        }else{
            return json(['status' => 'fail', 'msg' => '状态更新失败']);
        }
	}


    
    /**
     * 保存新建的资源
     *
     * @param  \think\Request  $request
     * @return \think\Response
     */
    public function save(Request $request)
    {
        // 权限拦截：添加权限
        if (!$this->hasPermission('category_add')) {
            return json(['status'=>'fail','msg'=>'无权限添加栏目']);
        }
        // 接收提交的数据
        $data = input('post.');
        
        // 检查 URL 名称是否合法（不允许包含斜杠）
        if (!empty($data['filename']) && !preg_match('/^[a-zA-Z0-9\-_]+$/', $data['filename'])) {
            return json(['msg' => 'URL名称只允许字母、数字、横线、下划线组成，不允许包含斜杠', 'status' => 'fail']);
        }

        // 检查 URL 名称是否已存在
        if ($data['filename'] && Db::name('category')->where(['filename' => $data['filename']])->find()) {
            return json(['msg' => 'URL名称已经存在，不能重复添加！', 'status' => 'fail']);
        }

        // 如果有外链，检查是否包含协议前缀
        if (!empty($data['outlink'])) {
            // 检查是否包含协议前缀 http:// 或 https://
            if (!preg_match('/^https?:\/\//i', $data['outlink'])) {
                // 如果不包含协议前缀，添加 http://
                $data['outlink'] = 'http://' . $data['outlink'];
            }
        }

        // 设置 isMenu 字段
        $cates = Db::name('category')->where('id', $data['pid'])->find();
        $data['isMenu'] = ($data['pid'] == 0) ? '0' : '1';

        // 获取模型信息
        $model = Db::name('model')->where(['id' => $data['model']])->find();

        if ($model['type'] == '1') {
            //设置了模型url的情况下
            if($model['url']==''){
                $model['link'] = 'page';
            }else{
                $model['link'] = $model['url'];
            }
        } else {
            if($model['url']==''){
                $model['link'] = 'list';
            }else{
                $model['link'] = $model['url'];
            }
        }

        // 分割名称字符串，批量上传
        $nameList = explode("、", $data['name']);
        foreach ($nameList as $k => $v) {
            $data['name'] = $v;
            $category = Db::name('category')->insertGetId($data);

            // 链接设定
            if ($data['filename'] == '') {
                $link = '/' .$model['link'] . '_' . $category.'/';
            } else {
                $link = '/' .$data['filename'].'/';
            }


            Db::name('category')->where('id', $category)->update(['link' => $link]);

            // 插入单页数据
            if ($model['type'] == '1') {
                $time = date('Y-m-d H:i:s');
                $single = Db::name('single')->insertGetId([
                    'scode' => $category,
                    'name' => $data['name'],
                    'title' => $data['name'],
                    'date' => $time,
                    'model' => $data['model'],
                    'status' => '1'
                ]);

                // 插入扩展字段
                $extFields = Db::name('extfield')->where(['model' => $data['model']])->select();
                foreach ($extFields as $field) {
                    Db::name('single_ext')->insert([
                        'single' => $single,
                        'model' => $field['model'],
                        'description' => $field['description'],
                        'type' => $field['type'],
                        'field' => $field['field']
                    ]);
                }
            }

            // 更新模型名称
            Db::name('category')->where(['model' => $model['id']])->update(['model_name' => $model['name']]);
        }

        if (!empty($category)) {
            $cat = Db::name('category')->find($category);
            $name = isset($cat['name']) ? $cat['name'] : '';
            $this->logAction('添加菜单管理，ID:' . $category . '，栏目名称:' . $name);
            $this->markSitemapDirty();
        }
        return $category ? json(['msg' => '添加成功', 'status' => 'success']) : json(['msg' => '添加失败', 'status' => 'fail']);
    }

    

    /**
     * 显示编辑资源表单页.
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function edit($id)
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('category_edit')) {
            if (request()->isAjax() || request()->isPost()) {
                return json(['status'=>'fail','msg'=>'无权限编辑栏目']);
            }
            return '<div style="display:flex;align-items:center;justify-content:center;height:80vh;font-size:22px;color:#c00;font-weight:bold;">当前用户无编辑栏目权限！</div>';
        }
        // 获取分类信息
        $edit = Db::name('category')->find($id);

        // 获取所有模型
        $model = Db::name('model')->where('status', 1)->order('sort asc, id asc')->select()->toArray();

        // 获取所有分类并生成树形结构
        $lst = Db::name('category')->order('id asc')->select();
        $lst = tree($lst);

        // 获取模板文件
        $result = array_column($model, 'details');
        $dir = './template/index';
        $files = scandir($dir);
        $res = array_diff($files, $result);
        $template = array_filter($res, function($item) {
            return substr($item, -5) === '.html';
        });

        // 获取扩展字段信息
        $category_ext = Db::name('category_ext')->where(['category' => $edit['id']])->order('id asc')->select();

        // 分配数据到视图
        View::assign([
            'edit' => $edit,
            'lst' => json_encode($lst, JSON_UNESCAPED_UNICODE),
            'model' => $model,
            'template' => $template,
            'category_ext'=>$category_ext,
        ]);

        return View::fetch('edit');
    }

   

    
    public function click()
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('category_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑栏目']);
        }
        // 接收提交的数据
        $data = input('post.');

        $cat = Db::name('category')->find($data['id']);
        $name = isset($cat['name']) ? $cat['name'] : '';
        Db::name('category')->where('id', $data['id'])->update([$data['field'] => $data['value']]);
        $this->logAction('修改栏目字段，ID:' . $data['id'] . '，栏目名称:' . $name . '，字段:' . $data['field'] . '，值:' . $data['value']);

    }

    /**
     * 保存更新的资源
     *
     * @param  \think\Request  $request
     * @param  int  $id
     * @return \think\Response
     */
    public function update()
    {
        // 权限拦截：编辑权限
        if (!$this->hasPermission('category_edit')) {
            return json(['status'=>'fail','msg'=>'无权限编辑栏目']);
        }
        // 接收提交的数据
        $data = input('post.');
        $id = $data['id'];

        // 获取数据库中的原始数据
        $originalData = Db::name('category')->where('id', $id)->find();

        // 获取 content_ext 表中的扩展字段数据
        $extFields = Db::name('category_ext')->where('category', $id)->select()->toArray();

        // 将扩展字段数据合并到原始数据中
        foreach ($extFields as $extField) {
            $originalData[$extField['field']] = $extField['value'];
        }

        
        // 比较数据是否有变化
        $hasChanges = false;
        foreach ($data as $key => $value) {
            $old = isset($originalData[$key]) ? $originalData[$key] : '';
            $old = is_null($old) ? '' : $old;
            $new = is_null($value) ? '' : $value;
            if ($old != $new) {
                $hasChanges = true;
                break;
            }
        }

        if (!$hasChanges) {
            return json(['status' => 'fail', 'msg' => '未做任何修改']);
        }


       





        // 检查 URL 名称是否合法（不允许包含斜杠）
        if (!empty($data['filename']) && !preg_match('/^[a-zA-Z0-9\-_]+$/', $data['filename'])) {
            return json(['msg' => 'URL名称只允许字母、数字、横线、下划线组成，不允许包含斜杠', 'status' => 'fail']);
        }

        // 检查 URL 名称是否已存在
        if ($data['filename']) {
            $existingCategory = Db::name('category')->where(['filename' => $data['filename']])->find();
            if ($existingCategory && $existingCategory['id'] != $id) {
                return json(['msg' => 'URL名称已经存在，不能重复添加！', 'status' => 'fail']);
            }
        }

        // 如果有外链，检查是否包含协议前缀
        if (!empty($data['outlink'])) {
            // 检查是否包含协议前缀 http:// 或 https://
            if (!preg_match('/^https?:\/\//i', $data['outlink'])) {
                // 如果不包含协议前缀，添加 http://
                $data['outlink'] = 'http://' . $data['outlink'];
            }
        }

        // 设置 isMenu 字段
        $cates = Db::name('category')->where('id', $data['pid'])->find();
        $data['isMenu'] = ($cates == null || $cates['pid'] == '0') ? '0' : '1';

       

        // 原栏目类型
        $edit=Db::name('category')->where(['id'=>$data['id']])->find();

        // 获取模型信息
        $model = Db::name('model')->where(['id' => $data['model']])->find();
        
        if ($model['type'] == '1') {
            //设置了模型url的情况下
            if($model['url']==''){
                $model['link'] = 'page';
            }else{
                $model['link'] = $model['url'];
            }
        } else {
            if($model['url']==''){
                $model['link'] = 'list';
            }else{
                $model['link'] = $model['url'];
            }
        }

         
        // 链接设定
        if ($data['filename'] == '') {
            $link = '/' .$model['link'] . '_' . $id.'/';
        } else {
            $link = '/' .$data['filename'].'/';
        }

        // 更新单页数据
        if ($model['type'] == '1') {

            //如果从原列表改成单页情况下
            $model_pid=Db::name('model')->where(['id'=>$edit['model']])->find();
            if($model_pid['type']=='2'){

                $content=Db::name('content')->where(['scode'=>$data['id']])->find();
                if($content){
                  return json(['msg'=>'该分类下还有内容，请先删除后修改', 'status' => 'fail']);
                }


                $time = date('Y-m-d H:i:s');
                $single = Db::name('single')->insertGetId([
                    'scode' => $data['id'],
                    'name' => $data['name'],
                    'title' => $data['name'],
                    'date' => $time,
                    'model' => $data['model'],
                    'status' => '1'
                ]);
                // 插入扩展字段
                $extFields = Db::name('extfield')->where(['model' => $data['model']])->select();
                foreach ($extFields as $field) {
                    Db::name('single_ext')->insert([
                        'single' => $single,
                        'model' => $field['model'],
                        'description' => $field['description'],
                        'type' => $field['type'],
                        'field' => $field['field']
                    ]);
                }
            } else {
                // 如果原来就是单页或从其他类型转换为单页，检查single是否存在，如果不存在则创建
                $existingSingle = Db::name('single')->where(['scode' => $id])->find();
                if (!$existingSingle) {
                    $time = date('Y-m-d H:i:s');
                    $single = Db::name('single')->insertGetId([
                        'scode' => $data['id'],
                        'name' => $data['name'],
                        'title' => $data['name'],
                        'date' => $time,
                        'model' => $data['model'],
                        'status' => '1'
                    ]);
                    // 插入扩展字段
                    $extFields = Db::name('extfield')->where(['model' => $data['model']])->select();
                    foreach ($extFields as $field) {
                        Db::name('single_ext')->insert([
                            'single' => $single,
                            'model' => $field['model'],
                            'description' => $field['description'],
                            'type' => $field['type'],
                            'field' => $field['field']
                        ]);
                    }
                } else {
                    // 如果single记录已存在，则更新
                    Db::name('single')->where(['scode' => $id])->update([
                        'name' => $data['name'],
                        'title' => $data['name'],
                        'model' => $data['model']
                    ]);
                }
            }
        }

        // 更新内容数据
        if ($model['type'] == '2') {

            //如果从原单页改成列表情况下
            $model_pid=Db::name('model')->where(['id'=>$edit['model']])->find();
            if($model_pid['type']=='1'){
                Db::name('single')->where(['scode'=>$data['id']])->delete();
                Db::name('single_ext')->where(['single'=>$data['id']])->delete();
            }

            $contentList = Db::name('content')->where(['scode' => $id])->select();
            foreach ($contentList as $content) {
                // 使用分类的 $link 作为内容链接的基础路径，去除链接末尾的斜杠
                $baseLink = rtrim(trim($link, '/'), '/');
                $contentLink = '/'.$baseLink . '/' . $content['id'] . '.html';
                Db::name('content')->where(['id' => $content['id']])->update([
                    'link' => $contentLink,
                    'name' => $data['name']
                ]);
            }
        }
        

        // 更新分类数据
        $category = Db::name('category')->strict(false)->where('id', $id)->update($data);
        
       
        Db::name('category')->where('id', $id)->update(['link' => $link]);

        

        // 更新模型名称
        Db::name('category')->where(['model' => $model['id']])->update(['model_name' => $model['name']]);

        // 处理自定义字段
        $prefix = 'ext_';
        $columns = array_filter($data, function($key) use ($prefix) {
            return strpos($key, $prefix) === 0;
        }, ARRAY_FILTER_USE_KEY);

        // 更新扩展字段数据
        foreach ($columns as $key => $value) {
            $column = Db::name('column')->where('field', $key)->find();
            Db::name('category_ext')->where(['category' => $id, 'field' => $column['field']])->update(['value' => $value]);
        }

        $cat = Db::name('category')->find($id);
        $name = isset($cat['name']) ? $cat['name'] : '';
        $this->logAction('更新菜单管理，ID:' . $id . '，栏目名称:' . $name);
        $this->markSitemapDirty();
        return json(['msg' => '更新成功', 'status' => 'success']);
    }
    /**
     * 删除指定资源
     *
     * @param  int  $id
     * @return \think\Response
     */
    public function delete($id)
    {
        // 权限拦截：删除权限
        if (!$this->hasPermission('category_delete')) {
            return json(['status'=>'fail','msg'=>'无权限删除栏目']);
        }
        // 检查是否存在子分类
        $hasChild = Db::name('category')->where('pid', $id)->find();
        if ($hasChild) {
            return json(['status' => 'fail', 'msg' => '删除失败，该分类下还有子分类']);
        }

        // 获取分类信息
        $category = Db::name('category')->find($id);
        if (!$category) {
            return json(['status' => 'fail', 'msg' => '分类不存在']);
        }

        // 获取模型信息
        $model = Db::name('model')->where(['id' => $category['model']])->find();

        // 删除单页数据
        if ($model['type'] == '1') {
            $single = Db::name('single')->where(['scode' => $id])->find();
            if ($single) {
                Db::name('single_ext')->where(['single' => $single['id']])->delete();
                Db::name('single')->where(['scode' => $id])->delete();
            }
        }

        // 删除内容数据
        if ($model['type'] == '2') {
            $contents = Db::name('content')->where(['scode' => $id])->select();
            foreach ($contents as $content) {
                Db::name('content_ext')->where(['content' => $content['id']])->delete();
            }
            Db::name('content')->where(['scode' => $id])->delete();
        }

        // 删除分类
        $result = Db::name('category')->where('id', $id)->delete();

        $name = isset($category['name']) ? $category['name'] : '';
        if ($result) {
            $this->logAction('删除菜单管理，ID:' . $id . '，栏目名称:' . $name);
            $this->markSitemapDirty();
        }
        return $result ? json(['status' => 'success', 'msg' => '删除成功']) : json(['status' => 'fail', 'msg' => '删除失败']);
    }
    
    private function markSitemapDirty()
    {
        try {
            (new \app\home\controller\Sitemap())->markChanged();
        } catch (\Throwable $e) {
            // 静默
        }
    }
}
